/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.entity.ContentType;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;

public class ResponseUtils {
    public static void writeOfJson(@NonNull HttpServletResponse response, @NonNull Object data) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(JSONObject.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0]));
        outputStream.flush();
        outputStream.close();
    }

    public static void writeOfOriginal(@NonNull HttpServletResponse response, @NonNull Object data) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(data.toString().getBytes());
        outputStream.flush();
        outputStream.close();
    }

    public static void writeOfFile(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull File file) throws IOException {
        MediaType mediaType;
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String fileBaseName = FilenameUtils.getName((String)file.getAbsolutePath());
        ServletContext servletContext = request.getServletContext();
        String mineType = servletContext.getMimeType(fileBaseName);
        try {
            mediaType = MediaType.parseMediaType((String)mineType);
        }
        catch (Exception e) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        response.setContentType(mediaType.getType());
        response.setHeader("Content-Disposition", "attachment;filename=".concat(fileBaseName));
        response.setContentLengthLong(file.length());
        FileUtils.copyFile((File)file, (OutputStream)response.getOutputStream());
    }
}

