/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.jwt;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import pro.haichuang.framework.base.enums.error.client.AuthorityErrorEnum;
import pro.haichuang.framework.base.exception.client.AuthorityException;
import pro.haichuang.framework.base.util.jwt.JwtPayload;

public class SecurityUtils {
    private static final ThreadLocal<JwtPayload> CONTEXT_HOLDER = new TransmittableThreadLocal();

    public static void setJwtPayload(@NonNull JwtPayload jwtPayload) {
        Assert.notNull((Object)jwtPayload, (String)"Only non-null JwtPayload instances are permitted");
        CONTEXT_HOLDER.set(jwtPayload);
    }

    @Nullable
    public static JwtPayload getJwtPayload() {
        return CONTEXT_HOLDER.get();
    }

    @NonNull
    public static JwtPayload getJwtPayloadOrNewInstance() {
        return CONTEXT_HOLDER.get() == null ? new JwtPayload() : CONTEXT_HOLDER.get();
    }

    @NonNull
    public static JwtPayload getJwtPayloadAndValidate() {
        JwtPayload jwtPayload = CONTEXT_HOLDER.get();
        if (jwtPayload == null) {
            throw new AuthorityException(AuthorityErrorEnum.ACCESS_BLOCKED, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return jwtPayload;
    }

    public static void remove() {
        CONTEXT_HOLDER.remove();
    }
}

