/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.mvc;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration(proxyBeanMethods=false)
public class JacksonConfig {
    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return jacksonObjectMapperBuilder -> {
            jacksonObjectMapperBuilder.serializerByType(BigInteger.class, (JsonSerializer)new ToStringSerializer());
            jacksonObjectMapperBuilder.serializerByType(Long.class, (JsonSerializer)new ToStringSerializer());
            jacksonObjectMapperBuilder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            jacksonObjectMapperBuilder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            jacksonObjectMapperBuilder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            jacksonObjectMapperBuilder.deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            jacksonObjectMapperBuilder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            jacksonObjectMapperBuilder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        };
    }

    public static class LocalTimeConverter
    implements Converter<String, LocalTime> {
        public LocalTime convert(String s) {
            return LocalTime.parse(s, DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
    }

    public static class LocalDateConverter
    implements Converter<String, LocalDate> {
        public LocalDate convert(String s) {
            return LocalDate.parse(s, DatePattern.NORM_DATE_FORMATTER);
        }
    }

    public static class LocalDateTimeConverter
    implements Converter<String, LocalDateTime> {
        public LocalDateTime convert(String s) {
            return LocalDateTime.parse(s, DatePattern.NORM_DATETIME_FORMATTER);
        }
    }
}

