/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.page;

import java.io.Serializable;
import java.util.Collection;
import pro.haichuang.framework.base.page.Pageable;
import pro.haichuang.framework.base.request.PageRequest;
import pro.haichuang.framework.base.response.vo.PageDetailVO;

public class PageDTO<T>
implements Pageable<T>,
Serializable {
    private static final long serialVersionUID = -6895490553746305660L;
    private Long pageNo = 1L;
    private Long pageSize = 10L;
    private Long totalCount = 0L;
    private Collection<T> content;

    public PageDTO() {
    }

    public PageDTO(long pageNo, long pageSize) {
        this();
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.adjustPageNo();
    }

    public PageDTO(long pageNo, long pageSize, long totalCount, Collection<T> content) {
        this(pageNo, pageSize);
        this.totalCount = totalCount;
        this.content = content;
        this.adjustPageNo();
    }

    public PageDTO(PageRequest pageRequest) {
        this();
        this.pageNo = pageRequest.getPageNo();
        this.pageSize = pageRequest.getPageSize();
    }

    public PageDTO(PageRequest pageRequest, long totalCount, Collection<T> content) {
        this(pageRequest);
        this.totalCount = totalCount;
        this.content = content;
    }

    public PageDTO(PageDetailVO pageDetailVO, Collection<T> content) {
        this(pageDetailVO.getPageNo(), pageDetailVO.getPageSize(), pageDetailVO.getTotalCount(), content);
        this.adjustPageNo();
    }

    public static <T> PageDTO<T> empty() {
        return new PageDTO<T>();
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getPageNo() {
        return this.pageNo;
    }

    @Override
    public long getTotalPage() {
        long totalPage = this.totalCount / this.pageSize;
        if (totalPage == 0L || this.totalCount % this.pageSize != 0L) {
            ++totalPage;
        }
        return totalPage;
    }

    @Override
    public boolean isFirstPage() {
        return this.pageNo <= 1L;
    }

    @Override
    public boolean isLastPage() {
        return this.pageNo >= this.getTotalPage();
    }

    @Override
    public long getNextPage() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1L;
    }

    @Override
    public long getPrePage() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1L;
    }

    public PageDTO<T> setTotalCount(long totalCount) {
        this.totalCount = Math.max(totalCount, 0L);
        return this;
    }

    public PageDTO<T> setPageSize(long pageSize) {
        this.pageSize = pageSize < 1L ? Long.valueOf(1000L) : Long.valueOf(Math.min(pageSize, 1000L));
        return this;
    }

    public PageDTO<T> setPageNo(long pageNo) {
        this.pageNo = Math.max(pageNo, 1L);
        this.adjustPageNo();
        return this;
    }

    @Override
    public Collection<T> getContent() {
        return this.content;
    }

    public PageDTO<T> setContent(Collection<T> content) {
        this.content = content;
        return this;
    }

    public void adjustPageNo() {
        if (this.pageNo == 1L) {
            return;
        }
        long totalPage = this.getTotalPage();
        if (this.pageNo > totalPage) {
            this.pageNo = totalPage;
        }
    }

    public String toString() {
        return "PageDTO{pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", totalCount=" + this.totalCount + ", content=" + this.content + '}';
    }
}

