/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import pro.haichuang.framework.base.exception.EnumIllegalArgumentException;

public interface BaseEnum {
    @JsonValue
    public String value();

    public String getReasonPhrase();

    public static <E extends BaseEnum> E resolve(String value, Class<E> enumClass) throws EnumIllegalArgumentException {
        BaseEnum[] enumConstants;
        if (!enumClass.isEnum()) {
            throw new EnumIllegalArgumentException(enumClass.getPackage().getName() + " is not an Enum");
        }
        BaseEnum enumValue = null;
        for (BaseEnum enumConstant : enumConstants = (BaseEnum[])enumClass.getEnumConstants()) {
            if (!enumConstant.value().equals(value)) continue;
            enumValue = enumConstant;
            break;
        }
        if (enumValue == null) {
            throw new EnumIllegalArgumentException("No matching [" + enumClass.getPackage().getName() + "] for [" + value + "]");
        }
        return (E)enumValue;
    }
}

