/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.page;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.Collection;
import pro.haichuang.framework.base.response.vo.PageDetailVO;

public interface Pageable<T> {
    public long getPageNo();

    public long getPageSize();

    public long getTotalCount();

    public long getTotalPage();

    public boolean isFirstPage();

    public boolean isLastPage();

    public long getNextPage();

    public long getPrePage();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    default public long offsetPageNo() {
        return this.getPageNo() > 0L ? (this.getPageNo() - 1L) * this.getPageSize() : 0L;
    }

    public Collection<T> getContent();

    default public PageDetailVO convertToPageDetailVO() {
        return new PageDetailVO(this.getPageNo(), this.getPageSize(), this.getTotalCount());
    }

    public static LocalDateTime formatEndDate(LocalDateTime endDateTime) {
        return endDateTime.plusDays(1L);
    }
}

