/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.common;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import pro.haichuang.framework.base.util.common.UUIDUtils;

public class FileUriUtils {
    @NonNull
    public static String concatFilename(@NonNull MultipartFile file, @Nullable String newFileName, @NonNull String fileType, String ... uploadPath) {
        Assert.notEmpty((Object[])uploadPath, (String)"\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String fileOriginalExtensionName = FilenameUtils.getExtension((String)file.getOriginalFilename());
        String fileNewName = newFileName != null && !newFileName.isEmpty() ? newFileName : (fileOriginalExtensionName != null && !fileOriginalExtensionName.isEmpty() ? UUIDUtils.random().concat(FilenameUtils.EXTENSION_SEPARATOR_STR).concat(fileOriginalExtensionName) : UUIDUtils.random());
        String relativeUploadPath = FilenameUtils.concat((String)String.join((CharSequence)"/", Arrays.asList(uploadPath)), (String)fileType);
        return FileUriUtils.formatFilename(FilenameUtils.concat((String)relativeUploadPath, (String)fileNewName), true);
    }

    @NonNull
    public static String concatFilename(@NonNull File file, @Nullable String newFileName, @NonNull String fileType, String ... uploadPath) {
        Assert.notEmpty((Object[])uploadPath, (String)"\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String fileExtensionName = FilenameUtils.getExtension((String)file.getName());
        String fileNewName = newFileName != null && !newFileName.isEmpty() ? newFileName : (!fileExtensionName.isEmpty() ? UUIDUtils.random().concat(FilenameUtils.EXTENSION_SEPARATOR_STR).concat(fileExtensionName) : UUIDUtils.random());
        String relativeUploadPath = FilenameUtils.concat((String)String.join((CharSequence)"/", Arrays.asList(uploadPath)), (String)fileType);
        return FileUriUtils.formatFilename(FilenameUtils.concat((String)relativeUploadPath, (String)fileNewName), true);
    }

    @NonNull
    public static String concatFilename(@NonNull String filePath, @Nullable String newFileName, @NonNull String fileType, String ... uploadPath) {
        Assert.notEmpty((Object[])uploadPath, (String)"\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String fileExtensionName = FilenameUtils.getExtension((String)filePath);
        String fileNewName = newFileName != null && !newFileName.isEmpty() ? newFileName : (!fileExtensionName.isEmpty() ? UUIDUtils.random().concat(FilenameUtils.EXTENSION_SEPARATOR_STR).concat(fileExtensionName) : UUIDUtils.random());
        String relativeUploadPath = FilenameUtils.concat((String)String.join((CharSequence)"/", Arrays.asList(uploadPath)), (String)fileType);
        return FileUriUtils.formatFilename(FilenameUtils.concat((String)relativeUploadPath, (String)fileNewName), true);
    }

    public static String formatFilename(@NonNull String filename, boolean isReplaceFirstSeparator) {
        filename = FilenameUtils.separatorsToUnix((String)filename);
        return isReplaceFirstSeparator && StringUtils.equals((CharSequence)String.valueOf(filename.charAt(0)), (CharSequence)"/") ? filename.substring(1) : filename;
    }
}

