/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;

public class IpUtils {
    private static final String UNKNOWN = "unknown";
    private static final Pattern ACCESS_IPV4_PATTERN = Pattern.compile("((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}");

    @NonNull
    public static String getIpv4Address(@NonNull HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if ((ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) && (ip = request.getHeader("Proxy-Client-IP")) != null && ip.contains(",") && ip.split(",").length > 1) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        } else {
            Matcher matcher = ACCESS_IPV4_PATTERN.matcher(ip);
            if (matcher.find()) {
                ip = matcher.group();
            }
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }
}

