/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.mybatis.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import pro.haichuang.framework.base.page.PageDTO;
import pro.haichuang.framework.base.request.PageRequest;
import pro.haichuang.framework.mybatis.domain.BaseDO;
import pro.haichuang.framework.mybatis.enums.error.MybatisServiceErrorEnum;
import pro.haichuang.framework.mybatis.exception.MybatisServiceApplication;

public interface BaseService<T extends BaseDO>
extends IService<T> {
    default public boolean isExistsByIdAndIgnore(@Nullable Long id) {
        if (id == null) {
            return false;
        }
        return this.countByIdAndValidate(id) != 0;
    }

    default public boolean isExistsByIdAndIgnore(@Nullable Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        return this.countByIdAndValidate(ids) != 0;
    }

    default public int countByIdAndIgnore(@Nullable Long id) {
        if (id == null) {
            return 0;
        }
        return this.count((Wrapper)new QueryWrapper().select(new String[]{"id"}).eq((Object)"id", (Object)id));
    }

    default public int countByIdAndIgnore(@Nullable Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        return this.count((Wrapper)new QueryWrapper().select(new String[]{"id"}).in((Object)"id", ids));
    }

    @Nullable
    default public T getByIdAndIgnore(@Nullable Long id) {
        if (id == null) {
            return null;
        }
        return (T)((BaseDO)this.getById(id));
    }

    default public Optional<T> getByIdAndIgnoreOpt(@Nullable Long id) {
        return Optional.ofNullable(this.getByIdAndIgnore(id));
    }

    default public List<T> listByIdAndIgnore(@Nullable Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.listByIds(ids);
    }

    @Nullable
    default public List<T> listAndIgnore(Wrapper<T> wrapper) {
        List result = this.list(wrapper);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    default public PageDTO<T> listPageAndIgnore(@Nullable PageRequest pageRequest) {
        if (pageRequest == null) {
            return new PageDTO(new PageRequest());
        }
        return new PageDTO(pageRequest).setContent((Collection)((Page)this.page((IPage)new Page((long)pageRequest.getPageNo(), (long)pageRequest.getPageSize()).addOrder(new OrderItem[]{OrderItem.desc((String)BaseService.toUnderlineCase("modifyTime"))}))).getRecords());
    }

    default public boolean saveAndIgnore(@Nullable T entity) {
        if (entity == null) {
            return false;
        }
        return this.save(BaseService.clearEntityDefaultParameterAndGet(entity, true, true, true));
    }

    default public boolean saveAndIgnore(@Nullable Collection<T> entities) {
        return this.saveAndIgnore(entities, 1000);
    }

    default public boolean saveAndIgnore(@Nullable Collection<T> entities, int batchSize) {
        if (entities == null || entities.isEmpty()) {
            return false;
        }
        return this.saveBatch(BaseService.clearEntityDefaultParameterAndGet(entities, true, true, true), batchSize);
    }

    default public boolean updateByIdAndIgnore(@Nullable T entity) {
        if (entity == null) {
            return false;
        }
        return this.updateById(BaseService.clearEntityDefaultParameterAndGet(entity));
    }

    default public boolean updateByIdAndIgnore(@Nullable Collection<T> entities) {
        return this.updateByIdAndIgnore(entities, 1000);
    }

    default public boolean updateByIdAndIgnore(@Nullable Collection<T> entities, int batchSize) {
        if (entities == null || entities.isEmpty()) {
            return false;
        }
        return this.updateBatchById(BaseService.clearEntityDefaultParameterAndGet(entities), batchSize);
    }

    default public boolean removeByIdAndIgnore(@Nullable Long id) {
        if (id == null) {
            return false;
        }
        return this.removeById(id);
    }

    default public boolean removeByIdAndIgnore(@Nullable Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        return this.removeByIds(ids);
    }

    default public boolean isExistsByIdAndValidate(Long id) throws MybatisServiceApplication {
        return this.isExistsByIdAndValidate(id, "\u7f51\u7edc\u5f00\u5c0f\u5dee\u4e86, \u8bf7\u7a0d\u540e\u518d\u8bd5 (\u256f\ufe4f\u2570)");
    }

    default public boolean isExistsByIdAndValidate(@Nullable Long id, String errorUserTip) throws MybatisServiceApplication {
        if (id == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return this.countByIdAndValidate(id) != 0;
    }

    default public boolean isExistsByIdAndValidate(@Nullable Collection<Long> ids) throws MybatisServiceApplication {
        return this.isExistsByIdAndValidate(ids, "\u7f51\u7edc\u5f00\u5c0f\u5dee\u4e86, \u8bf7\u7a0d\u540e\u518d\u8bd5 (\u256f\ufe4f\u2570)");
    }

    default public boolean isExistsByIdAndValidate(@Nullable Collection<Long> ids, String errorUserTip) throws MybatisServiceApplication {
        if (ids == null || ids.isEmpty()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return this.countByIdAndValidate(ids) != 0;
    }

    default public int countByIdAndValidate(@Nullable Long id) throws MybatisServiceApplication {
        return this.countByIdAndValidate(id, null);
    }

    default public int countByIdAndValidate(@Nullable Long id, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (id == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return this.count((Wrapper)new QueryWrapper().select(new String[]{"id"}).eq((Object)"id", (Object)id));
    }

    default public int countByIdAndValidate(@Nullable Collection<Long> ids) throws MybatisServiceApplication {
        return this.countByIdAndValidate(ids, null);
    }

    default public int countByIdAndValidate(@Nullable Collection<Long> ids, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (ids == null || ids.isEmpty()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return this.count((Wrapper)new QueryWrapper().select(new String[]{"id"}).in((Object)"id", ids));
    }

    default public T getByIdAndValidate(@Nullable Long id) throws MybatisServiceApplication {
        return this.getByIdAndValidate(id, null);
    }

    default public T getByIdAndValidate(@Nullable Long id, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (id == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        BaseDO entity = (BaseDO)this.getById(id);
        if (entity == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL, errorUserTip);
        }
        return (T)entity;
    }

    default public List<T> listByIdAndValidate(@Nullable Collection<Long> ids) throws MybatisServiceApplication {
        return this.listByIdAndValidate(ids, null);
    }

    default public List<T> listByIdAndValidate(Wrapper<T> wrapper) throws MybatisServiceApplication {
        return this.listAndValidate(wrapper, null);
    }

    default public List<T> listByIdAndValidate(@Nullable Collection<Long> ids, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (ids == null || ids.isEmpty()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        List entities = this.listByIds(ids);
        if (entities == null || entities.isEmpty()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL, errorUserTip);
        }
        return entities;
    }

    default public List<T> listAndValidate(Wrapper<T> wrapper, @Nullable String errorUserTip) throws MybatisServiceApplication {
        List entities = this.list(wrapper);
        if (entities == null || entities.isEmpty()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return entities;
    }

    default public PageDTO<T> listPageAndValidate(@Nullable PageRequest pageRequest) throws MybatisServiceApplication {
        return this.listPageAndValidate(pageRequest, null);
    }

    default public PageDTO<T> listPageAndValidate(@Nullable PageRequest pageRequest, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (pageRequest == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return new PageDTO(pageRequest).setContent((Collection)((Page)this.page((IPage)new Page((long)pageRequest.getPageNo(), (long)pageRequest.getPageSize()).addOrder(new OrderItem[]{OrderItem.desc((String)BaseService.toUnderlineCase("modifyTime"))}))).getRecords());
    }

    default public boolean saveAndValidate(@Nullable T entity) throws MybatisServiceApplication {
        return this.saveAndValidate(entity, null);
    }

    default public boolean saveAndValidate(@Nullable T entity, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (entity == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return this.save(BaseService.clearEntityDefaultParameterAndGet(entity, true, true, true));
    }

    default public boolean saveAndValidate(@Nullable Collection<T> entities) throws MybatisServiceApplication {
        return this.saveAndValidate(entities, 1000, null);
    }

    default public boolean saveAndValidate(@Nullable Collection<T> entities, @Nullable String errorUserTip) throws MybatisServiceApplication {
        return this.saveAndValidate(entities, 1000, errorUserTip);
    }

    default public boolean saveAndValidate(@Nullable Collection<T> entities, int batchSize) throws MybatisServiceApplication {
        return this.saveAndValidate(entities, batchSize, null);
    }

    default public boolean saveAndValidate(@Nullable Collection<T> entities, int batchSize, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (entities == null || entities.isEmpty()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        return this.saveBatch(BaseService.clearEntityDefaultParameterAndGet(entities, true, true, true), batchSize);
    }

    default public boolean updateByIdAndValidate(@Nullable T entity) throws MybatisServiceApplication {
        if (entity == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL);
        }
        Method getIdMethod = BaseService.validateIdExistsAndGetIdMethod(entity);
        if (this.countByIdAndValidate((Long)getIdMethod.invoke(entity, new Object[0])) == 0) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL);
        }
        return this.updateByIdAndValidate(entity, null);
    }

    default public boolean updateByIdAndValidate(@Nullable T entity, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (entity == null) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        Method getIdMethod = BaseService.validateIdExistsAndGetIdMethod(entity);
        if (this.countByIdAndValidate((Long)getIdMethod.invoke(entity, new Object[0])) == 0) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL, errorUserTip);
        }
        return this.updateById(BaseService.clearEntityDefaultParameterAndGet(entity));
    }

    default public boolean updateByIdAndValidate(@Nullable Collection<T> entities) throws MybatisServiceApplication {
        return this.updateByIdAndValidate(entities, 1000);
    }

    default public boolean updateByIdAndValidate(@Nullable Collection<T> entities, @Nullable String errorUserTip) throws MybatisServiceApplication {
        return this.updateByIdAndValidate(entities, 1000, errorUserTip);
    }

    default public boolean updateByIdAndValidate(@Nullable Collection<T> entities, int batchSize) throws MybatisServiceApplication {
        return this.updateByIdAndValidate(entities, batchSize, null);
    }

    default public boolean updateByIdAndValidate(@Nullable Collection<T> entities, int batchSize, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (CollectionUtils.isEmpty(entities)) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.ID_IS_NULL, errorUserTip);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (BaseDO entity : entities) {
            ids.add((Long)BaseService.validateIdExistsAndGetIdMethod(entity).invoke((Object)entity, new Object[0]));
        }
        if (this.countByIdAndValidate(ids) != entities.size()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL, errorUserTip);
        }
        return this.updateBatchById(BaseService.clearEntityDefaultParameterAndGet(entities), batchSize);
    }

    default public boolean removeByIdAndValidate(@Nullable Long id) throws MybatisServiceApplication {
        return this.removeByIdAndValidate(id, null);
    }

    default public boolean removeByIdAndValidate(@Nullable Long id, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (this.countByIdAndValidate(id) == 0) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL, errorUserTip);
        }
        return this.removeById(id);
    }

    default public boolean removeByIdAndValidate(@Nullable Collection<Long> ids) throws MybatisServiceApplication {
        return this.removeByIdAndValidate(ids, null);
    }

    default public boolean removeByIdAndValidate(@Nullable Collection<Long> ids, @Nullable String errorUserTip) throws MybatisServiceApplication {
        if (ids == null || this.countByIdAndValidate(ids) != ids.size()) {
            throw new MybatisServiceApplication(MybatisServiceErrorEnum.RESULT_SET_IS_NULL, errorUserTip);
        }
        return this.removeByIds(ids);
    }

    public static <T extends BaseDO> T clearEntityDefaultParameterAndGet(T entity) {
        return BaseService.clearEntityDefaultParameterAndGet(entity, false, true, true);
    }

    public static <T extends BaseDO> List<T> clearEntityDefaultParameterAndGet(Collection<T> entities) {
        return entities.stream().map(entity -> BaseService.clearEntityDefaultParameterAndGet(entity, false, true, true)).collect(Collectors.toList());
    }

    public static <T extends BaseDO> T clearEntityDefaultParameterAndGet(T entity, boolean isClearId, boolean isClearCreateTime, boolean isClearModifyTime) {
        if (isClearId) {
            String setIdMethodName = "set".concat("id".substring(0, 1).toUpperCase().concat("id".substring(1)));
            Method setIdMethod = BaseService.getDeepDeclareMethod(entity, setIdMethodName, BaseDO.ID_CLASS);
            if (setIdMethod == null) {
                throw new NoSuchMethodException(entity.getClass().getName() + "." + setIdMethodName + "(" + BaseDO.ID_CLASS.getName() + ")");
            }
            setIdMethod.invoke(entity, new Object[]{null});
        }
        if (isClearCreateTime) {
            String setCreateTimeMethodName = "set".concat("createTime".substring(0, 1).toUpperCase().concat("createTime".substring(1)));
            Method setCreateTimeMethod = BaseService.getDeepDeclareMethod(entity, setCreateTimeMethodName, BaseDO.CREATE_TIME_CLASS);
            if (setCreateTimeMethod == null) {
                throw new NoSuchMethodException(entity.getClass().getName() + "." + setCreateTimeMethodName + "(" + BaseDO.ID_CLASS.getName() + ")");
            }
            setCreateTimeMethod.invoke(entity, new Object[]{null});
        }
        if (isClearModifyTime) {
            String setModifyTimeMethodName = "set".concat("modifyTime".substring(0, 1).toUpperCase().concat("modifyTime".substring(1)));
            Method setModifyTimeMethod = BaseService.getDeepDeclareMethod(entity, setModifyTimeMethodName, BaseDO.MODIFY_TIME_CLASS);
            if (setModifyTimeMethod == null) {
                throw new NoSuchMethodException(entity.getClass().getName() + "." + setModifyTimeMethodName + "(" + BaseDO.ID_CLASS.getName() + ")");
            }
            setModifyTimeMethod.invoke(entity, new Object[]{null});
        }
        return entity;
    }

    public static <T extends BaseDO> Collection<T> clearEntityDefaultParameterAndGet(Collection<T> entities, boolean isClearId, boolean isClearCreateTime, boolean isClearModifyTime) {
        return entities.stream().map(entity -> BaseService.clearEntityDefaultParameterAndGet(entity, isClearId, isClearCreateTime, isClearModifyTime)).collect(Collectors.toList());
    }

    public static <T extends BaseDO> Method validateIdExistsAndGetIdMethod(T entity) {
        String idMethodFormat = "id".substring(0, 1).toUpperCase().concat("id".substring(1));
        String setIdMethodName = "set".concat(idMethodFormat);
        Method setIdMethod = BaseService.getDeepDeclareMethod(entity, setIdMethodName, BaseDO.ID_CLASS);
        String getIdMethodName = "get".concat(idMethodFormat);
        Method getIdMethod = BaseService.getDeepDeclareMethod(entity, getIdMethodName, new Class[0]);
        if (setIdMethod == null) {
            throw new NoSuchMethodException(entity.getClass().getName() + "." + setIdMethodName + "(" + BaseDO.ID_CLASS.getName() + ")");
        }
        if (getIdMethod == null) {
            throw new NoSuchMethodException(entity.getClass().getName() + "." + getIdMethodName + "(" + BaseDO.ID_CLASS.getName() + ")");
        }
        return getIdMethod;
    }

    @Nullable
    public static <T extends BaseDO> Method getDeepDeclareMethod(T entity, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = entity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static String toUnderlineCase(String value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

