/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.mybatis.generate;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.querys.MySqlQuery;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.springframework.stereotype.Service;
import pro.haichuang.framework.mybatis.domain.BaseDO;
import pro.haichuang.framework.mybatis.enums.error.MybatisGenerateErrorEnum;
import pro.haichuang.framework.mybatis.exception.MybatisGenerateErrorApplication;
import pro.haichuang.framework.mybatis.generate.config.CodeBasicConfig;
import pro.haichuang.framework.mybatis.generate.config.CodeDataSourceConfig;
import pro.haichuang.framework.mybatis.generate.config.CodePackageConfig;
import pro.haichuang.framework.mybatis.service.BaseService;

@Service
public class MybatisGenerateCodeService {
    public static final String DEFAULT_SUPER_MAPPER_CLASS = "com.baomidou.mybatisplus.core.mapper.BaseMapper";
    public static final String DEFAULT_SUPER_SERVICE_CLASS = "pro.haichuang.framework.mybatis.service.BaseService";
    public static final String DEFAULT_SUPER_SERVICE_IMPL_CLASS = "pro.haichuang.framework.mybatis.service.BaseServiceImpl";

    public void generate(final CodeBasicConfig codeBasicConfig, CodeDataSourceConfig codeDataSourceConfig, CodePackageConfig codePackageConfig) throws MybatisGenerateErrorApplication {
        if (codeDataSourceConfig.getUrl() == null || codeDataSourceConfig.getUrl().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.DATA_SOURCE_URL_IS_BLANK);
        }
        if (codeDataSourceConfig.getUsername() == null || codeDataSourceConfig.getUsername().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.DATA_SOURCE_USERNAME_IS_BLANK);
        }
        if (codeDataSourceConfig.getPassword() == null || codeDataSourceConfig.getPassword().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.DATA_SOURCE_PASSWORD_IS_BLANK);
        }
        if (codePackageConfig.getParentModelName() == null || codePackageConfig.getParentModelName().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.PACKAGE_PARENT_MODEL_NAME_IS_BLANK);
        }
        AutoGenerator ag = new AutoGenerator();
        ag.setGlobalConfig(this.initGlobalConfig(codeBasicConfig, codePackageConfig));
        ag.setDataSource(this.initDataSourceConfig(codeDataSourceConfig));
        ag.setStrategy(this.initStrategyConfig(codeDataSourceConfig));
        ag.setPackageInfo(this.initPackageConfig(codePackageConfig));
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("version", codeBasicConfig.getVersion());
                map.put("dateTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                this.setMap(map);
            }
        };
        ag.setCfg(cfg);
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setEntity(null);
        templateConfig.setService(null);
        templateConfig.setServiceImpl(null);
        templateConfig.setMapper(null);
        templateConfig.setXml(null);
        templateConfig.setController(null);
        if (codeBasicConfig.getOutputType() == CodeBasicConfig.OutputType.ONLY_DOMAIN) {
            ag.setTemplate(templateConfig.setEntity("/templates/entity.java")).execute();
            return;
        }
        templateConfig.setService("/templates/service.java");
        templateConfig.setServiceImpl("/templates/serviceImpl.java");
        templateConfig.setMapper("/templates/mapper.java");
        templateConfig.setXml("/templates/mapper.xml");
        templateConfig.setController("/templates/controller.java");
        if (codeBasicConfig.getOutputType() != CodeBasicConfig.OutputType.ALL_EXCLUDE_DOMAIN) {
            templateConfig.setEntity("/templates/entity.java");
        }
        ag.setTemplate(templateConfig).execute();
    }

    private GlobalConfig initGlobalConfig(CodeBasicConfig codeBasicConfig, CodePackageConfig codePackageConfig) {
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(codePackageConfig.getOutputDir());
        gc.setFileOverride(true);
        gc.setOpen(true);
        gc.setEnableCache(false);
        gc.setAuthor(codeBasicConfig.getAuthor());
        gc.setKotlin(false);
        gc.setSwagger2(codeBasicConfig.getEnableSwagger().booleanValue());
        gc.setActiveRecord(false);
        gc.setBaseResultMap(false);
        gc.setDateType(DateType.TIME_PACK);
        gc.setBaseColumnList(false);
        gc.setEntityName("%sDO");
        gc.setMapperName("%sMapper");
        gc.setXmlName("%sMapper");
        gc.setServiceName("%sService");
        gc.setServiceImplName("%sServiceImpl");
        gc.setControllerName("%sController");
        gc.setIdType(IdType.ASSIGN_ID);
        return gc;
    }

    private DataSourceConfig initDataSourceConfig(CodeDataSourceConfig codeDataSourceConfig) {
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbQuery((IDbQuery)new MySqlQuery());
        dsc.setDbType(DbType.MYSQL);
        dsc.setSchemaName(null);
        dsc.setTypeConvert((ITypeConvert)new MySqlTypeConvert());
        dsc.setUrl(codeDataSourceConfig.getUrl());
        dsc.setDriverName(codeDataSourceConfig.getDriver());
        dsc.setUsername(codeDataSourceConfig.getUsername());
        dsc.setPassword(codeDataSourceConfig.getPassword());
        return dsc;
    }

    private StrategyConfig initStrategyConfig(CodeDataSourceConfig codeDataSourceConfig) {
        StrategyConfig sc = new StrategyConfig();
        sc.setCapitalMode(false);
        sc.setSkipView(false);
        sc.setNameConvert(null);
        sc.setNaming(NamingStrategy.underline_to_camel);
        sc.setColumnNaming(NamingStrategy.underline_to_camel);
        if (codeDataSourceConfig.getTablePrefix() != null && codeDataSourceConfig.getTablePrefix().length() != 0) {
            sc.setTablePrefix(new String[]{codeDataSourceConfig.getTablePrefix()});
        }
        sc.setFieldPrefix(new String[]{""});
        sc.setSuperEntityClass(BaseDO.class);
        sc.setSuperEntityColumns(new String[]{"id", BaseService.toUnderlineCase("createTime"), BaseService.toUnderlineCase("modifyTime")});
        sc.setSuperMapperClass(DEFAULT_SUPER_MAPPER_CLASS);
        sc.setSuperServiceClass(DEFAULT_SUPER_SERVICE_CLASS);
        sc.setSuperServiceImplClass(DEFAULT_SUPER_SERVICE_IMPL_CLASS);
        if (codeDataSourceConfig.getInclude() != null && codeDataSourceConfig.getInclude().length != 0) {
            sc.setInclude(codeDataSourceConfig.getInclude());
        }
        sc.setEntitySerialVersionUID(true);
        sc.setEntityColumnConstant(false);
        sc.setChainModel(true);
        sc.setEntityLombokModel(true);
        sc.setEntityBooleanColumnRemoveIsPrefix(true);
        sc.setRestControllerStyle(true);
        sc.setControllerMappingHyphenStyle(false);
        sc.setEntityTableFieldAnnotationEnable(true);
        sc.setVersionFieldName(null);
        sc.setLogicDeleteFieldName("logic_delete");
        sc.setTableFillList(null);
        sc.setEnableSqlFilter(true);
        return sc;
    }

    private PackageConfig initPackageConfig(CodePackageConfig codePackageConfig) {
        PackageConfig pc = new PackageConfig();
        pc.setParent(codePackageConfig.getOutputPackage());
        pc.setModuleName(codePackageConfig.getParentModelName());
        pc.setEntity(codePackageConfig.getEntityPackageName());
        pc.setService(codePackageConfig.getServicePackageName());
        pc.setServiceImpl(codePackageConfig.getServiceImplPackageName());
        pc.setMapper(codePackageConfig.getMapperPackageName());
        pc.setXml(codePackageConfig.getMapperXmlPackageName());
        pc.setController(codePackageConfig.getControllerPackageName());
        pc.setPathInfo(null);
        return pc;
    }
}

