/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.mybatis.generate;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.TemplateType;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.stereotype.Service;
import pro.haichuang.framework.mybatis.domain.BaseDO;
import pro.haichuang.framework.mybatis.enums.error.MybatisGenerateErrorEnum;
import pro.haichuang.framework.mybatis.exception.MybatisGenerateErrorApplication;
import pro.haichuang.framework.mybatis.generate.config.CodeBasicConfig;
import pro.haichuang.framework.mybatis.generate.config.CodeDataSourceConfig;
import pro.haichuang.framework.mybatis.generate.config.CodePackageConfig;
import pro.haichuang.framework.mybatis.service.BaseService;
import pro.haichuang.framework.mybatis.service.BaseServiceImpl;

@Service
public class MybatisGenerateCodeService {
    public void generate(CodeBasicConfig codeBasicConfig, CodeDataSourceConfig codeDataSourceConfig, CodePackageConfig codePackageConfig) throws MybatisGenerateErrorApplication {
        if (codeDataSourceConfig.getUrl() == null || codeDataSourceConfig.getUrl().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.DATA_SOURCE_URL_IS_BLANK);
        }
        if (codeDataSourceConfig.getUsername() == null || codeDataSourceConfig.getUsername().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.DATA_SOURCE_USERNAME_IS_BLANK);
        }
        if (codeDataSourceConfig.getPassword() == null || codeDataSourceConfig.getPassword().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.DATA_SOURCE_PASSWORD_IS_BLANK);
        }
        if (codePackageConfig.getParentModelName() == null || codePackageConfig.getParentModelName().length() == 0) {
            throw new MybatisGenerateErrorApplication(MybatisGenerateErrorEnum.PACKAGE_PARENT_MODEL_NAME_IS_BLANK);
        }
        String url = codeDataSourceConfig.getUrl();
        String username = codeDataSourceConfig.getUsername();
        String password = codeDataSourceConfig.getPassword();
        FastAutoGenerator.create((String)url, (String)username, (String)password).globalConfig(this.initGlobalConfig(codeBasicConfig, codePackageConfig)).packageConfig(this.initPackageConfig(codePackageConfig)).strategyConfig(this.initStrategyConfig(codeDataSourceConfig)).templateConfig(this.initTemplateConfig(codeBasicConfig)).injectionConfig(this.initInjectionConfig(codeBasicConfig)).execute();
    }

    private Consumer<GlobalConfig.Builder> initGlobalConfig(CodeBasicConfig codeBasicConfig, CodePackageConfig codePackageConfig) {
        return builder -> builder.fileOverride().outputDir(codePackageConfig.getOutputDir()).author(codeBasicConfig.getAuthor()).enableSwagger().dateType(DateType.TIME_PACK);
    }

    private Consumer<PackageConfig.Builder> initPackageConfig(CodePackageConfig codePackageConfig) {
        return builder -> builder.parent(codePackageConfig.getOutputPackage()).moduleName(codePackageConfig.getParentModelName()).entity(codePackageConfig.getEntityPackageName()).service(codePackageConfig.getServicePackageName()).serviceImpl(codePackageConfig.getServiceImplPackageName()).mapper(codePackageConfig.getMapperPackageName()).xml(codePackageConfig.getMapperXmlPackageName()).controller(codePackageConfig.getControllerPackageName()).pathInfo(Collections.singletonMap(OutputFile.mapperXml, codePackageConfig.getOutputResourcesDir()));
    }

    private Consumer<TemplateConfig.Builder> initTemplateConfig(CodeBasicConfig codeBasicConfig) {
        return builder -> {
            if (codeBasicConfig.getOutputType() == CodeBasicConfig.OutputType.ONLY_DOMAIN) {
                builder.disable(new TemplateType[]{TemplateType.ENTITY});
            }
            if (codeBasicConfig.getOutputType() != CodeBasicConfig.OutputType.ALL_EXCLUDE_DOMAIN) {
                builder.entity("/templates/entity.java");
            }
            builder.service("/templates/service.java").serviceImpl("/templates/serviceImpl.java").mapper("/templates/mapper.java").mapperXml("/templates/mapper.xml").controller("/templates/controller.xml");
        };
    }

    private Consumer<InjectionConfig.Builder> initInjectionConfig(CodeBasicConfig codeBasicConfig) {
        return builder -> builder.customMap(Collections.singletonMap("since", codeBasicConfig.getSince()));
    }

    private Consumer<StrategyConfig.Builder> initStrategyConfig(CodeDataSourceConfig codeDataSourceConfig) {
        return builder -> {
            if (codeDataSourceConfig.getTablePrefix() != null && !codeDataSourceConfig.getTablePrefix().isEmpty()) {
                builder.addTablePrefix(new String[]{codeDataSourceConfig.getTablePrefix()});
            }
            if (codeDataSourceConfig.getInclude().length > 0) {
                builder.addInclude(codeDataSourceConfig.getInclude());
            }
            builder.entityBuilder().superClass(BaseDO.class).enableChainModel().enableLombok().enableRemoveIsPrefix().enableTableFieldAnnotation().versionColumnName("version").versionPropertyName("version").logicDeleteColumnName(BaseService.toUnderlineCase("logicDelete")).logicDeletePropertyName("logicDelete").addSuperEntityColumns(new String[]{"id", BaseService.toUnderlineCase("createTime"), BaseService.toUnderlineCase("modifyTime")}).formatFileName("%sDO").build();
            builder.controllerBuilder().enableRestStyle().build();
            builder.serviceBuilder().superServiceClass(BaseService.class).superServiceImplClass(BaseServiceImpl.class).formatServiceFileName("%sService").formatServiceImplFileName("%sServiceImpl").build();
            builder.mapperBuilder().enableMapperAnnotation().formatMapperFileName("%sMapper").formatXmlFileName("%sXml").build();
        };
    }
}

