/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.mybatis.config.druid.advert;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.alibaba.druid.spring.boot.autoconfigure.properties.DruidStatProperties;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.haichuang.framework.mybatis.config.druid.advert.filter.DruidAdvertFilter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@AutoConfigureAfter(value={DruidDataSourceAutoConfigure.class})
@ConditionalOnProperty(name={"spring.datasource.druid.stat-view-servlet.enabled"}, havingValue="true", matchIfMissing=true)
public class DruidAdvertConfig {
    @Bean
    public FilterRegistrationBean<DruidAdvertFilter> removeDruidAdvert(DruidStatProperties properties) {
        DruidStatProperties.StatViewServlet config = properties.getStatViewServlet();
        String pattern = StringUtils.isNotBlank((CharSequence)config.getUrlPattern()) ? config.getUrlPattern() : "/druid/*";
        String commonJsPattern = pattern.replaceAll("\\*", "js/common.js");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new DruidAdvertFilter());
        registrationBean.addUrlPatterns(new String[]{commonJsPattern});
        return registrationBean;
    }
}

