/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.redis.config.interceptor;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import pro.haichuang.framework.base.dto.HttpServletRequestDTO;
import pro.haichuang.framework.base.enums.BaseEnum;
import pro.haichuang.framework.base.enums.error.client.RequestServerErrorEnum;
import pro.haichuang.framework.base.response.ResultVO;
import pro.haichuang.framework.base.util.common.RequestUtils;
import pro.haichuang.framework.base.util.common.ResponseUtils;
import pro.haichuang.framework.redis.annotation.RepeatRequestValid;
import pro.haichuang.framework.redis.key.RedisKey;
import pro.haichuang.framework.redis.service.RedisService;

public class RepeatRequestInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepeatRequestInterceptor.class);
    private static final String LOG_TAG = "\u91cd\u590d\u8bf7\u6c42\u62e6\u622a\u5668";
    @Autowired
    private RedisService redisService;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Method method;
        RepeatRequestValid repeatRequestValidAnnotation;
        if (handler instanceof HandlerMethod && (repeatRequestValidAnnotation = (method = (handlerMethod = (HandlerMethod)handler).getMethod()).getAnnotation(RepeatRequestValid.class)) != null) {
            HttpServletRequestDTO httpServletRequestDTO = RequestUtils.parseInfo((HttpServletRequest)request, (Method)method);
            String clientIp = httpServletRequestDTO.getClientIp();
            String apiMessage = httpServletRequestDTO.getApiMessage();
            Long userId = httpServletRequestDTO.getUserId();
            String fullMethodName = httpServletRequestDTO.getFullMethodName();
            Map parameterMap = request.getParameterMap();
            String parameterString = "";
            if (parameterMap != null && !parameterMap.isEmpty()) {
                parameterString = JSONObject.toJSONString((Object)parameterMap);
            } else if (RequestUtils.isJsonRequest((HttpServletRequest)request)) {
                parameterString = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
            }
            String repeatRedisKey = RedisKey.repeatRequest(repeatRequestValidAnnotation.preKey(), clientIp, String.valueOf(userId), request.getRequestURI());
            String rdbParameterString = (String)this.redisService.get(repeatRedisKey);
            if (rdbParameterString == null) {
                this.redisService.set(repeatRedisKey, parameterString, repeatRequestValidAnnotation.value());
            } else {
                LOGGER.warn("[{}] \u62e6\u622a\u8bf7\u6c42 [apiMessage: {}, requestUri: {}, method: {}, clientIp: {}, userId: {}, params: {}]", new Object[]{LOG_TAG, apiMessage, request.getRequestURI(), fullMethodName, clientIp, userId, parameterString});
                ResponseUtils.writeOfJson((HttpServletResponse)response, (Object)ResultVO.other((BaseEnum)RequestServerErrorEnum.REPEAT_REQUEST, (String)"\u8bf7\u6c42\u901f\u5ea6\u8fc7\u5feb, \u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                return false;
            }
        }
        return true;
    }
}

