/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.redis.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.RedisTemplate;
import pro.haichuang.framework.redis.service.RedisService;

public class DefaultRedisServiceImpl
implements RedisService {
    private final RedisTemplate<String, Object> redisTemplate;

    public DefaultRedisServiceImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    @Override
    public boolean expire(String key, long expireTime) {
        if (expireTime > 0L) {
            Boolean result = this.redisTemplate.expire((Object)key, expireTime, TimeUnit.SECONDS);
            return result != null && result != false;
        }
        return false;
    }

    @Override
    public long getExpire(String key) {
        Long result = this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
        return result == null ? -1L : result;
    }

    @Override
    public boolean hasKey(String key) {
        Boolean result = this.redisTemplate.hasKey((Object)key);
        return result != null && result != false;
    }

    @Override
    public void del(String ... key) {
        if (key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete(Arrays.asList(key));
            }
        }
    }

    @Override
    public <V> V get(String key) {
        return (V)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public void set(String key, Object value, long expireTime) {
        if (expireTime > 0L) {
            this.redisTemplate.opsForValue().set((Object)key, value, expireTime, TimeUnit.SECONDS);
        } else {
            this.set(key, value);
        }
    }

    @Override
    public long incr(String key, long factor) {
        if (factor <= 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e [0]");
        }
        Long result = this.redisTemplate.opsForValue().increment((Object)key, factor);
        return result == null ? -1L : result;
    }

    @Override
    public long decr(String key, long factor) {
        if (factor <= 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e [0]");
        }
        Long result = this.redisTemplate.opsForValue().increment((Object)key, -factor);
        return result == null ? -1L : result;
    }

    @Override
    public <V> V hget(String key, String item) {
        return (V)this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    @Override
    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public void hmset(String key, Map<String, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    @Override
    public void hmset(String key, Map<String, Object> map, long expireTime) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
        if (expireTime > 0L) {
            this.expire(key, expireTime);
        }
    }

    @Override
    public void hset(String key, String item, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
    }

    @Override
    public void hset(String key, String item, Object value, long expireTime) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
        if (expireTime > 0L) {
            this.expire(key, expireTime);
        }
    }

    @Override
    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    @Override
    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    @Override
    public double hincr(String key, String item, double factor) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, factor);
    }

    @Override
    public double hdecr(String key, String item, double factor) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -factor);
    }

    @Override
    public <V> Set<V> sGet(String key) {
        Set result = this.redisTemplate.opsForSet().members((Object)key);
        return result == null ? null : result.stream().map(v -> v).collect(Collectors.toSet());
    }

    @Override
    public boolean sHasKey(String key, Object value) {
        Boolean result = this.redisTemplate.opsForSet().isMember((Object)key, value);
        return result != null && result != false;
    }

    @Override
    public long sSet(String key, Object ... values) {
        Long result = this.redisTemplate.opsForSet().add((Object)key, values);
        return result == null ? -1L : result;
    }

    @Override
    public long sSet(String key, long expireTime, Object ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, values);
        if (expireTime > 0L) {
            this.expire(key, expireTime);
        }
        return count == null ? -1L : count;
    }

    @Override
    public long sGetSize(String key) {
        Long result = this.redisTemplate.opsForSet().size((Object)key);
        return result == null ? -1L : result;
    }

    @Override
    public long sdel(String key, Object ... values) {
        Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
        return count == null ? -1L : count;
    }

    @Override
    public <V> List<V> lGet(String key, long start, long end) {
        List result = this.redisTemplate.opsForList().range((Object)key, start, end);
        return result == null ? null : result.stream().map(v -> v).collect(Collectors.toList());
    }

    @Override
    public long lGetSize(String key) {
        Long result = this.redisTemplate.opsForList().size((Object)key);
        return result == null ? -1L : result;
    }

    @Override
    public <V> V lGetIndex(String key, long index) {
        return (V)this.redisTemplate.opsForList().index((Object)key, index);
    }

    @Override
    public void lSet(String key, Object value) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    @Override
    public void lSet(String key, Object value, long expireTime) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
        if (expireTime > 0L) {
            this.expire(key, expireTime);
        }
    }

    @Override
    public void lSet(String key, List<Object> value) {
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    @Override
    public void lSet(String key, List<Object> value, long expireTime) {
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
        if (expireTime > 0L) {
            this.expire(key, expireTime);
        }
    }

    @Override
    public void lEditIndex(String key, long index, Object value) {
        this.redisTemplate.opsForList().set((Object)key, index, value);
    }

    @Override
    public long lDel(String key, long count, Object value) {
        Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
        return remove == null ? -1L : remove;
    }
}

