/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunoss.config.aspect;

import io.jsonwebtoken.lang.Collections;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import pro.haichuang.framework.base.response.vo.MultiVO;
import pro.haichuang.framework.base.response.vo.PageVO;
import pro.haichuang.framework.base.response.vo.SingleVO;
import pro.haichuang.framework.sdk.aliyunoss.annotation.EnableOssUrlConvert;
import pro.haichuang.framework.sdk.aliyunoss.annotation.OssUrl;
import pro.haichuang.framework.sdk.aliyunoss.config.properties.AliYunOssProperties;

@Aspect
public class OssUrlAspect {
    @Autowired
    private AliYunOssProperties aliYunOssProperties;

    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object proceed;
        block7: {
            Collection collection;
            block8: {
                block6: {
                    MethodSignature signature = (MethodSignature)point.getSignature();
                    Method method = signature.getMethod();
                    EnableOssUrlConvert enableOssUrlConvert = method.getAnnotation(EnableOssUrlConvert.class);
                    if (enableOssUrlConvert != null) {
                        Object[] args = point.getArgs();
                        Parameter[] parameters = method.getParameters();
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i] == null) continue;
                            if (args[i] instanceof String && parameters[i].getAnnotation(OssUrl.class) != null) {
                                String tempUrl = (String)args[i];
                                args[i] = tempUrl.replace(this.aliYunOssProperties.getBucketDomain(), "");
                                continue;
                            }
                            this.ossUrlConvert(args[i], true);
                        }
                    }
                    if (!((proceed = point.proceed()) instanceof SingleVO)) break block6;
                    this.ossUrlConvert(((SingleVO)proceed).getData(), false);
                    break block7;
                }
                if (!(proceed instanceof MultiVO)) break block8;
                collection = ((MultiVO)proceed).getData();
                if (Collections.isEmpty((Collection)collection)) break block7;
                for (Object obj : collection) {
                    this.ossUrlConvert(obj, false);
                }
                break block7;
            }
            if (proceed instanceof PageVO && !Collections.isEmpty((Collection)(collection = ((PageVO)proceed).getData()))) {
                for (Object obj : collection) {
                    this.ossUrlConvert(obj, false);
                }
            }
        }
        return proceed;
    }

    private void ossUrlConvert(Object obj, boolean isRequestObj) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        if (obj != null) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = obj.getClass().getDeclaredFields()) {
                if (declaredField.getAnnotation(OssUrl.class) == null) continue;
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(declaredField.getName(), obj.getClass());
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                Object originUrl = readMethod.invoke(obj, new Object[0]);
                if (originUrl == null) continue;
                writeMethod.invoke(obj, this.getNewOssUrl(originUrl, isRequestObj));
            }
        }
    }

    private Object getNewOssUrl(Object originOssUrl, boolean isRequestObj) {
        String bucketDomain = this.aliYunOssProperties.getBucketDomain();
        ArrayList newOssUrl = originOssUrl;
        if (originOssUrl instanceof Collection) {
            Collection originOssUrls = originOssUrl;
            ArrayList newOssUrls = new ArrayList(originOssUrls.size());
            Iterator iterator = originOssUrls.iterator();
            while (iterator.hasNext()) {
                Object tempOriginOssUrl;
                Object tempOssUrl = tempOriginOssUrl = iterator.next();
                if (tempOriginOssUrl instanceof String) {
                    tempOssUrl = isRequestObj ? ((String)tempOriginOssUrl).replace(bucketDomain, "") : bucketDomain + tempOriginOssUrl;
                }
                newOssUrls.add(tempOssUrl);
            }
            newOssUrl = newOssUrls;
        } else if (originOssUrl instanceof String) {
            newOssUrl = isRequestObj ? ((String)((Object)originOssUrl)).replace(bucketDomain, "") : bucketDomain + originOssUrl;
        }
        return newOssUrl;
    }
}

