/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunoss.config.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import pro.haichuang.framework.base.enums.error.client.RequestParamErrorEnum;
import pro.haichuang.framework.base.exception.client.RequestParamException;

@ConfigurationProperties(prefix="haichuang.sdk.aliyunoss")
public class AliYunOssProperties {
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private String endpoint;

    public String getBucketDomain() {
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            throw new RequestParamException(RequestParamErrorEnum.PARAMETER_EMPTY, "[Endpoint\u5730\u57df\u8282\u70b9] \u672a\u5728Yaml\u8fdb\u884c\u914d\u7f6e");
        }
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            throw new RequestParamException(RequestParamErrorEnum.PARAMETER_EMPTY, "[BucketName] \u672a\u5728Yaml\u8fdb\u884c\u914d\u7f6e");
        }
        return "https://".concat(this.bucketName).concat(".").concat(this.endpoint.replaceAll("^(http|https)", "").replaceAll("^/.*", ""));
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

