/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunoss.util;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;
import pro.haichuang.framework.base.util.common.FileUriUtils;
import pro.haichuang.framework.sdk.aliyunoss.enums.error.AliYunOssUploadErrorEnum;
import pro.haichuang.framework.sdk.aliyunoss.exception.AliYunOssUploadException;

public class AliYunOssUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliYunOssUtils.class);
    private static final String LOG_TAG = "[sdk-aliyunoss] AliYunOss\u5de5\u5177\u7c7b";

    public static String uploadByMultipart(MultipartFile uploadFile, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException, IOException {
        return AliYunOssUtils.uploadByMultipart(uploadFile, null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByMultipart(MultipartFile uploadFile, @Nullable String newFileName, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException, IOException {
        String resultFilePath = AliYunOssUtils.baseFileUploadByMultipart(new LinkedList<MultipartFile>(Collections.singletonList(uploadFile)), newFileName != null ? new LinkedList<String>(Collections.singletonList(newFileName)) : null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath).get(0);
        LOGGER.info("[{}] \u7b80\u5355\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, resultFilePath});
        return resultFilePath;
    }

    public static String uploadByPath(String absoluteFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        return AliYunOssUtils.uploadByPath(absoluteFilePath, null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByPath(String absoluteFilePath, @Nullable String newFileName, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        return AliYunOssUtils.uploadByFile(new File(absoluteFilePath), newFileName, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByFile(File uploadFile, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        return AliYunOssUtils.uploadByFile(uploadFile, null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByFile(File uploadFile, @Nullable String newFileName, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        String resultFilePath = AliYunOssUtils.baseFileUploadByFile(new LinkedList<File>(Collections.singletonList(uploadFile)), newFileName != null ? new LinkedList<String>(Collections.singletonList(newFileName)) : null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath).get(0);
        LOGGER.info("[{}] \u7b80\u5355\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, resultFilePath});
        return resultFilePath;
    }

    public static List<String> uploadByMultipart(Collection<MultipartFile> uploadFiles, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException, IOException {
        return AliYunOssUtils.uploadByMultipart(new LinkedList<MultipartFile>(uploadFiles), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> uploadByMultipart(LinkedList<MultipartFile> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException, IOException {
        if (uploadFiles.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}, uploadFiles: {}]", new Object[]{LOG_TAG, bucketName, uploadFiles});
            return new ArrayList<String>();
        }
        List<String> resultFilePaths = AliYunOssUtils.baseFileUploadByMultipart(uploadFiles, newFileNames, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
        LOGGER.info("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPaths: {}]", new Object[]{LOG_TAG, bucketName, resultFilePaths});
        return resultFilePaths;
    }

    public static List<String> uploadByPath(Collection<String> absoluteFilePaths, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        return AliYunOssUtils.uploadByPath(new LinkedList<String>(absoluteFilePaths), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> uploadByPath(LinkedList<String> absoluteFilePaths, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        if (absoluteFilePaths.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}, absoluteFilePaths: {}]", new Object[]{LOG_TAG, bucketName, absoluteFilePaths});
            return new ArrayList<String>();
        }
        List<String> resultFilePaths = AliYunOssUtils.uploadByFile(absoluteFilePaths.stream().map(File::new).collect(LinkedList::new, LinkedList::add, LinkedList::addAll), newFileNames, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
        LOGGER.info("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPaths: {}]", new Object[]{LOG_TAG, bucketName, resultFilePaths});
        return resultFilePaths;
    }

    public static List<String> uploadByFile(Collection<File> uploadFiles, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        return AliYunOssUtils.uploadByFile(new LinkedList<File>(uploadFiles), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> uploadByFile(LinkedList<File> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        if (uploadFiles.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}, uploadFiles: {}]", new Object[]{LOG_TAG, bucketName, uploadFiles});
            return new ArrayList<String>();
        }
        List<String> resultFilePaths = AliYunOssUtils.baseFileUploadByFile(uploadFiles, newFileNames, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
        LOGGER.info("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPaths: {}]", new Object[]{LOG_TAG, bucketName, resultFilePaths});
        return resultFilePaths;
    }

    public static void downloadToResponse(String ossFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AliYunOssUtils.downloadToResponse(ossFilePath, accessKeyId, accessKeySecret, bucketName, endPoint, null, request, response);
    }

    public static void downloadToResponse(String ossFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, @Nullable String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MediaType mediaType;
        String fileBaseName = FilenameUtils.getName((String)(fileName != null && !fileName.isEmpty() ? fileName : ossFilePath));
        File file = AliYunOssUtils.downloadToFile(ossFilePath, accessKeyId, accessKeySecret, bucketName, endPoint, fileBaseName);
        ServletContext servletContext = request.getServletContext();
        String mineType = servletContext.getMimeType(fileBaseName);
        try {
            mediaType = MediaType.parseMediaType((String)mineType);
        }
        catch (Exception e) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        response.setContentType(mediaType.getType());
        response.setHeader("Content-Disposition", ContentDisposition.attachment().filename(fileBaseName, StandardCharsets.UTF_8).build().toString());
        response.setContentLengthLong(file.length());
        FileUtils.copyFile((File)file, (OutputStream)response.getOutputStream());
    }

    public static File downloadToFile(String ossFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) {
        return AliYunOssUtils.downloadToFile(ossFilePath, accessKeyId, accessKeySecret, bucketName, endPoint, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadToFile(String ossFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, @Nullable String fileName) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(endPoint, accessKeyId, accessKeySecret);
            ossFilePath = FileUriUtils.formatFilename((String)ossFilePath, (boolean)true);
            String fileBaseName = FilenameUtils.getName((String)(fileName != null && !fileName.isEmpty() ? fileName : ossFilePath));
            File file = new File(fileBaseName);
            ossClient.getObject(new GetObjectRequest(bucketName, ossFilePath), file);
            File file2 = file;
            return file2;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadToFile(String ossFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, @Nullable File outFile) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(endPoint, accessKeyId, accessKeySecret);
            ossFilePath = FileUriUtils.formatFilename((String)ossFilePath, (boolean)true);
            outFile = outFile != null ? outFile : new File(ossFilePath);
            ossClient.getObject(new GetObjectRequest(bucketName, ossFilePath), outFile);
            File file = outFile;
            return file;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteObject(String ossFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(endPoint, accessKeyId, accessKeySecret);
            ossClient.deleteObject(bucketName, FileUriUtils.formatFilename((String)ossFilePath, (boolean)true));
            LOGGER.info("[{}] \u5220\u9664\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, ossFilePath});
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public static List<String> deleteObject(Collection<String> ossFilePaths, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) {
        return AliYunOssUtils.deleteObject(ossFilePaths, false, accessKeyId, accessKeySecret, bucketName, endPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> deleteObject(Collection<String> ossFilePaths, boolean quiet, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) {
        if (ossFilePaths.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u5220\u9664\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, ossFilePaths});
            return new ArrayList<String>();
        }
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(endPoint, accessKeyId, accessKeySecret);
            List formatOssFilePaths = ossFilePaths.stream().map(path -> FileUriUtils.formatFilename((String)path, (boolean)true)).collect(Collectors.toList());
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName).withKeys(formatOssFilePaths);
            deleteObjectsRequest.setQuiet(quiet);
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(deleteObjectsRequest);
            LOGGER.info("[{}] \u6279\u91cf\u5220\u9664\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, ossFilePaths});
            List list = deleteObjectsResult.getDeletedObjects();
            return list;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public static List<String> baseFileUploadByMultipart(Collection<MultipartFile> files, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException, IOException {
        return AliYunOssUtils.baseFileUploadByMultipart(new LinkedList<MultipartFile>(files), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> baseFileUploadByMultipart(LinkedList<MultipartFile> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException, IOException {
        if (uploadFiles.stream().anyMatch(item -> item == null || item.isEmpty())) {
            throw new AliYunOssUploadException(AliYunOssUploadErrorEnum.NOT_EXISTS);
        }
        if (newFileNames != null && newFileNames.size() != uploadFiles.size()) {
            throw new AliYunOssUploadException(AliYunOssUploadErrorEnum.ORIGIN_DATA_AND_FILE_NAME_SIZE_MISMATCH);
        }
        ArrayList<String> resultFilePaths = new ArrayList<String>();
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(endPoint, accessKeyId, accessKeySecret);
            for (int i = 0; i < uploadFiles.size(); ++i) {
                String fileRelativeName = FileUriUtils.concatFilename((MultipartFile)uploadFiles.get(i), (String)(newFileNames != null ? newFileNames.get(i) : null), (String)fileType, (String[])uploadPath);
                ossClient.putObject(bucketName, fileRelativeName, uploadFiles.get(i).getInputStream());
                String resultFilePath = FileUriUtils.formatFilename((String)FilenameUtils.concat((String)"/", (String)fileRelativeName), (boolean)false);
                resultFilePaths.add(resultFilePath);
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return resultFilePaths;
    }

    private static List<String> baseFileUploadByFile(Collection<File> uploadFiles, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        return AliYunOssUtils.baseFileUploadByFile(new LinkedList<File>(uploadFiles), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> baseFileUploadByFile(LinkedList<File> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws AliYunOssUploadException {
        if (uploadFiles.stream().anyMatch(item -> item == null || !item.exists())) {
            throw new AliYunOssUploadException(AliYunOssUploadErrorEnum.NOT_EXISTS);
        }
        if (uploadFiles.stream().anyMatch(item -> !item.isFile())) {
            throw new AliYunOssUploadException(AliYunOssUploadErrorEnum.NOT_FILE);
        }
        if (newFileNames != null && newFileNames.size() != uploadFiles.size()) {
            throw new AliYunOssUploadException(AliYunOssUploadErrorEnum.ORIGIN_DATA_AND_FILE_NAME_SIZE_MISMATCH);
        }
        ArrayList<String> resultFilePaths = new ArrayList<String>();
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(endPoint, accessKeyId, accessKeySecret);
            for (int i = 0; i < uploadFiles.size(); ++i) {
                String fileAbsolutePath = uploadFiles.get(i).getAbsolutePath();
                String fileRelativeName = FileUriUtils.concatFilename((String)fileAbsolutePath, (String)(newFileNames != null ? newFileNames.get(i) : null), (String)fileType, (String[])uploadPath);
                ossClient.putObject(bucketName, fileRelativeName, new File(fileAbsolutePath));
                String resultFilePath = FileUriUtils.formatFilename((String)FilenameUtils.concat((String)"/", (String)fileRelativeName), (boolean)false);
                resultFilePaths.add(resultFilePath);
            }
            ArrayList<String> arrayList = resultFilePaths;
            return arrayList;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }
}

