/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunoss.service;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;
import pro.haichuang.framework.base.enums.upload.UploadTypeEnum;
import pro.haichuang.framework.sdk.aliyunoss.config.properties.AliYunOssProperties;
import pro.haichuang.framework.sdk.aliyunoss.enums.error.AliYunOssConfigErrorEnum;
import pro.haichuang.framework.sdk.aliyunoss.enums.error.AliYunOssUploadErrorEnum;
import pro.haichuang.framework.sdk.aliyunoss.exception.AliYunOssConfigException;
import pro.haichuang.framework.sdk.aliyunoss.exception.AliYunOssUploadException;
import pro.haichuang.framework.sdk.aliyunoss.service.AliYunOssService;
import pro.haichuang.framework.sdk.aliyunoss.util.AliYunOssUtils;

public class DefaultAliYunOssServiceImpl
implements AliYunOssService {
    private static final String[] DEFAULT_PATH_OF_BIZ_NAME = new String[]{"temp"};
    @Autowired
    private AliYunOssProperties aliYunOssProperties;

    @Override
    public String uploadByMultipart(MultipartFile uploadFile, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByMultipart(uploadFile, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByMultipart(MultipartFile uploadFile, String newFileName, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByMultipart(uploadFile, newFileName, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByMultipart(List<MultipartFile> uploadFiles, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByMultipart(uploadFiles, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByMultipart(LinkedList<MultipartFile> uploadFiles, LinkedList<String> newFileNames, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByMultipart(uploadFiles, newFileNames, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByPath(String absoluteFilePath, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByPath(absoluteFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByPath(String absoluteFilePath, String newFileName, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByPath(absoluteFilePath, newFileName, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByPath(List<String> absoluteFilePaths, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByPath(absoluteFilePaths, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByPath(LinkedList<String> absoluteFilePaths, LinkedList<String> newFileNames, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByPath(absoluteFilePaths, newFileNames, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByFile(File absoluteFilePath, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByFile(absoluteFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByFile(File absoluteFilePath, String newFileName, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByFile(absoluteFilePath, newFileName, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByFile(List<File> absoluteFilePaths, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByFile(absoluteFilePaths, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByFile(LinkedList<File> absoluteFilePaths, LinkedList<String> newFileNames, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return AliYunOssUtils.uploadByFile(absoluteFilePaths, newFileNames, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public void downloadToResponse(String ossFilePath, HttpServletRequest request, HttpServletResponse response) {
        this.validateProperties();
        AliYunOssUtils.downloadToResponse(ossFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), request, response);
    }

    @Override
    public void downloadToResponse(String ossFilePath, @Nullable String fileName, HttpServletRequest request, HttpServletResponse response) {
        this.validateProperties();
        AliYunOssUtils.downloadToResponse(ossFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), fileName, request, response);
    }

    @Override
    public File downloadToFile(String ossFilePath) {
        this.validateProperties();
        return AliYunOssUtils.downloadToFile(ossFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint());
    }

    @Override
    public File downloadToFile(String ossFilePath, @Nullable String fileName) {
        this.validateProperties();
        return AliYunOssUtils.downloadToFile(ossFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), fileName);
    }

    @Override
    public File downloadToFile(String ossFilePath, @Nullable File file) {
        this.validateProperties();
        return AliYunOssUtils.downloadToFile(ossFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint(), file);
    }

    @Override
    public void deleteObject(String ossFilePath) {
        this.validateProperties();
        AliYunOssUtils.deleteObject(ossFilePath, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint());
    }

    @Override
    public List<String> deleteObject(Collection<String> ossFilePaths) {
        this.validateProperties();
        return AliYunOssUtils.deleteObject(ossFilePaths, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint());
    }

    @Override
    public List<String> deleteObject(Collection<String> ossFilePaths, boolean quiet) {
        this.validateProperties();
        return AliYunOssUtils.deleteObject(ossFilePaths, quiet, this.aliYunOssProperties.getAccessKeyId(), this.aliYunOssProperties.getAccessKeySecret(), this.aliYunOssProperties.getBucketName(), this.aliYunOssProperties.getEndpoint());
    }

    private void validateProperties() {
        String accessKeyId = this.aliYunOssProperties.getAccessKeyId();
        String accessKeySecret = this.aliYunOssProperties.getAccessKeySecret();
        String bucketName = this.aliYunOssProperties.getBucketName();
        String endpoint = this.aliYunOssProperties.getEndpoint();
        if (accessKeyId == null || accessKeyId.isEmpty()) {
            throw new AliYunOssConfigException(AliYunOssConfigErrorEnum.ACCESS_KEY_ID_NOT_CONFIGURED);
        }
        if (accessKeySecret == null || accessKeySecret.isEmpty()) {
            throw new AliYunOssConfigException(AliYunOssConfigErrorEnum.ACCESS_KEY_SECRET_NOT_CONFIGURED);
        }
        if (bucketName == null || bucketName.isEmpty()) {
            throw new AliYunOssConfigException(AliYunOssConfigErrorEnum.BUCKET_NAME_NOT_CONFIGURED);
        }
        if (endpoint == null || endpoint.isEmpty()) {
            throw new AliYunOssConfigException(AliYunOssConfigErrorEnum.END_POINT_NOT_CONFIGURED);
        }
    }

    private void validateParams(@Nullable UploadTypeEnum uploadTypeEnum) {
        if (uploadTypeEnum == null) {
            throw new AliYunOssUploadException(AliYunOssUploadErrorEnum.UPLOAD_FILE_TYPE_IS_NULL);
        }
    }
}

