/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunoss.config.aspect;

import io.jsonwebtoken.lang.Collections;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import pro.haichuang.framework.base.response.vo.MultiVO;
import pro.haichuang.framework.base.response.vo.PageVO;
import pro.haichuang.framework.base.response.vo.SingleVO;
import pro.haichuang.framework.sdk.aliyunoss.annotation.OssUrl;
import pro.haichuang.framework.sdk.aliyunoss.config.properties.AliYunOssProperties;

@Aspect
public class OssUrlAspect {
    @Autowired
    private AliYunOssProperties aliYunOssProperties;

    @Around(value="@annotation(pro.haichuang.framework.sdk.aliyunoss.annotation.EnableOssUrlConvert)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object proceed;
        block6: {
            Collection collection;
            String addPrefixUrl;
            block7: {
                block5: {
                    MethodSignature signature = (MethodSignature)point.getSignature();
                    Method method = signature.getMethod();
                    addPrefixUrl = this.aliYunOssProperties.getBucketDomain();
                    String delPrefixUrl = this.aliYunOssProperties.getBucketDomain();
                    Object[] args = point.getArgs();
                    Parameter[] parameters = method.getParameters();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] == null) continue;
                        if (args[i] instanceof String && parameters[i].getAnnotation(OssUrl.class) != null) {
                            String tempUrl = (String)args[i];
                            args[i] = tempUrl.replace(delPrefixUrl, "");
                            continue;
                        }
                        this.ossUrlConvert(args[i], true, addPrefixUrl);
                    }
                    proceed = point.proceed();
                    if (!(proceed instanceof SingleVO)) break block5;
                    this.ossUrlConvert(((SingleVO)proceed).getData(), false, addPrefixUrl);
                    break block6;
                }
                if (!(proceed instanceof MultiVO)) break block7;
                collection = ((MultiVO)proceed).getData();
                if (Collections.isEmpty((Collection)collection)) break block6;
                for (Object obj : collection) {
                    this.ossUrlConvert(obj, false, addPrefixUrl);
                }
                break block6;
            }
            if (proceed instanceof PageVO && !Collections.isEmpty((Collection)(collection = ((PageVO)proceed).getData()))) {
                for (Object obj : collection) {
                    this.ossUrlConvert(obj, false, addPrefixUrl);
                }
            }
        }
        return proceed;
    }

    private void ossUrlConvert(Object obj, boolean isRequestObj, String addPrefixUrl) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        if (obj != null) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = obj.getClass().getDeclaredFields()) {
                if (declaredField.getAnnotation(OssUrl.class) == null) continue;
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(declaredField.getName(), obj.getClass());
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                Object originUrl = readMethod.invoke(obj, new Object[0]);
                if (originUrl == null) continue;
                writeMethod.invoke(obj, this.getNewOssUrl(originUrl, isRequestObj, addPrefixUrl));
            }
        }
    }

    private Object getNewOssUrl(Object originOssUrl, boolean isRequestObj, String addPrefixUrl) {
        ArrayList newOssUrl = originOssUrl;
        if (originOssUrl instanceof Collection) {
            Collection originOssUrls = originOssUrl;
            ArrayList newOssUrls = new ArrayList(originOssUrls.size());
            Iterator iterator = originOssUrls.iterator();
            while (iterator.hasNext()) {
                Object tempOriginOssUrl;
                Object tempOssUrl = tempOriginOssUrl = iterator.next();
                if (tempOriginOssUrl instanceof String) {
                    tempOssUrl = isRequestObj ? ((String)tempOriginOssUrl).replace(addPrefixUrl, "") : addPrefixUrl + tempOriginOssUrl;
                }
                newOssUrls.add(tempOssUrl);
            }
            newOssUrl = newOssUrls;
        } else if (originOssUrl instanceof String) {
            newOssUrl = isRequestObj ? ((String)((Object)originOssUrl)).replace(addPrefixUrl, "") : addPrefixUrl + originOssUrl;
        }
        return newOssUrl;
    }
}

