/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunsms.service;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import pro.haichuang.framework.sdk.aliyunsms.config.properties.AliYunSmsProperties;
import pro.haichuang.framework.sdk.aliyunsms.enums.error.AliYunSmsConfigErrorEnum;
import pro.haichuang.framework.sdk.aliyunsms.exception.AliYunSmsConfigException;
import pro.haichuang.framework.sdk.aliyunsms.service.AliYunSmsService;
import pro.haichuang.framework.sdk.aliyunsms.util.AliYunSmsUtils;

public class DefaultAliYunSmsServiceImpl
implements AliYunSmsService {
    @Autowired
    private AliYunSmsProperties aliYunSmsProperties;

    @Override
    public boolean send(@Nullable String signName, @Nullable String templateCode, String phoneNumbers, JSONObject templateParam) {
        this.validateProperties();
        if (signName == null || signName.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.SIGN_NAME_NOT_CONFIGURED);
        }
        if (templateCode == null || templateCode.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.TEMPLATE_CODE_NOT_CONFIGURED);
        }
        return AliYunSmsUtils.send(this.aliYunSmsProperties.getAccessKeyId(), this.aliYunSmsProperties.getAccessKeySecret(), signName, templateCode, phoneNumbers, templateParam);
    }

    @Override
    public boolean send(@Nullable String templateCode, String phoneNumbers, JSONObject templateParam) {
        this.validateProperties();
        String signName = this.aliYunSmsProperties.getSignName();
        if (signName == null || signName.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.SIGN_NAME_NOT_CONFIGURED);
        }
        if (templateCode == null || templateCode.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.TEMPLATE_CODE_NOT_CONFIGURED);
        }
        return AliYunSmsUtils.send(this.aliYunSmsProperties.getAccessKeyId(), this.aliYunSmsProperties.getAccessKeySecret(), this.aliYunSmsProperties.getSignName(), templateCode, phoneNumbers, templateParam);
    }

    @Override
    public boolean send(String phoneNumbers, JSONObject templateParam) {
        this.validateProperties();
        String signName = this.aliYunSmsProperties.getSignName();
        String defaultTemplateCode = this.aliYunSmsProperties.getDefaultTemplateCode();
        if (signName == null || signName.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.SIGN_NAME_NOT_CONFIGURED);
        }
        if (defaultTemplateCode == null || defaultTemplateCode.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.TEMPLATE_CODE_NOT_CONFIGURED);
        }
        return AliYunSmsUtils.send(this.aliYunSmsProperties.getAccessKeyId(), this.aliYunSmsProperties.getAccessKeySecret(), this.aliYunSmsProperties.getSignName(), this.aliYunSmsProperties.getDefaultTemplateCode(), phoneNumbers, templateParam);
    }

    private void validateProperties() {
        String accessKeyId = this.aliYunSmsProperties.getAccessKeyId();
        String accessKeySecret = this.aliYunSmsProperties.getAccessKeySecret();
        if (accessKeyId == null || accessKeyId.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.ACCESS_KEY_ID_NOT_CONFIGURED);
        }
        if (accessKeySecret == null || accessKeySecret.isEmpty()) {
            throw new AliYunSmsConfigException(AliYunSmsConfigErrorEnum.ACCESS_KEY_SECRET_NOT_CONFIGURED);
        }
    }
}

