/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.aliyunsms.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import pro.haichuang.framework.base.exception.ThirdPartyException;

public class AliYunSmsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliYunSmsUtils.class);
    private static final String LOG_TAG = "AliYunSms\u5de5\u5177\u7c7b";
    private static final String REGION_ID = "cn-hangzhou";
    private static final String SYS_DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String SYS_VERSION = "2017-05-25";
    private static final String SYS_ACTION = "SendSms";

    @NonNull
    public static boolean send(@NonNull String accessKeyId, @NonNull String accessKeySecret, @NonNull String signName, @NonNull String templateCode, @NonNull String phoneNumbers, @Nullable JSONObject templateParam) throws ThirdPartyException {
        CommonRequest request = AliYunSmsUtils.createRequest();
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateCode);
        if (templateParam != null && templateParam.size() != 0) {
            request.putQueryParameter("TemplateParam", templateParam.toJSONString());
        }
        return AliYunSmsUtils.baseSend(accessKeyId, accessKeySecret, request);
    }

    public static boolean sendBatch(@NonNull String accessKeyId, @NonNull String accessKeySecret, @NonNull List<String> signNames, @NonNull String templateCode, @NonNull List<String> phones, @Nullable JSONArray templateParam) throws ThirdPartyException {
        CommonRequest request = AliYunSmsUtils.createRequest();
        request.putQueryParameter("PhoneNumberJson", JSONObject.toJSONString(phones));
        request.putQueryParameter("SignNameJson", JSONObject.toJSONString(signNames));
        request.putQueryParameter("TemplateCode", templateCode);
        if (templateParam != null && templateParam.size() != 0) {
            request.putQueryParameter("TemplateParamJson", templateParam.toJSONString());
        }
        return AliYunSmsUtils.baseSend(accessKeyId, accessKeySecret, request);
    }

    @NonNull
    private static IAcsClient getClient(@NonNull String accessKeyId, @NonNull String accessKeySecret) {
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)accessKeySecret);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    @NonNull
    private static CommonRequest createRequest() {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(SYS_DOMAIN);
        request.setSysVersion(SYS_VERSION);
        request.setSysAction(SYS_ACTION);
        return request;
    }

    private static boolean baseSend(@NonNull String accessKeyId, @NonNull String accessKeySecret, @NonNull CommonRequest request) throws ThirdPartyException {
        try {
            AliYunSmsUtils.getClient(accessKeyId, accessKeySecret).getCommonResponse(request);
            return true;
        }
        catch (ClientException e) {
            LOGGER.error("[{}] \u53d1\u9001\u9a8c\u8bc1\u7801\u5f02\u5e38 [requestId: {}, errorCode: {}, errorMessage: {}, errorType: {}, errorDescription: {}]", new Object[]{LOG_TAG, e.getRequestId(), e.getErrCode(), e.getErrMsg(), e.getErrorType(), e.getErrorDescription()});
            throw new ThirdPartyException(e.getErrCode(), e.getErrMsg());
        }
    }
}

