/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.chuanglansms.service;

import cn.hutool.core.util.ReUtil;
import org.springframework.beans.factory.annotation.Autowired;
import pro.haichuang.framework.sdk.chuanglansms.config.properties.ChuangLanSmsProperties;
import pro.haichuang.framework.sdk.chuanglansms.enums.error.ChuangLanSmsConfigErrorEnum;
import pro.haichuang.framework.sdk.chuanglansms.enums.error.ChuangLanSmsSendErrorEnum;
import pro.haichuang.framework.sdk.chuanglansms.exception.ChuangLanSmsConfigException;
import pro.haichuang.framework.sdk.chuanglansms.exception.ChuangLanSmsSendException;
import pro.haichuang.framework.sdk.chuanglansms.response.SendResponse;
import pro.haichuang.framework.sdk.chuanglansms.service.ChuangLanSmsService;
import pro.haichuang.framework.sdk.chuanglansms.util.ChuangLanSmsUtils;

public class DefaultChuangLanSmsServiceImpl
implements ChuangLanSmsService {
    @Autowired
    private ChuangLanSmsProperties chuangLanSmsProperties;

    @Override
    public SendResponse send(String signName, String message, String phoneNumbers) throws ChuangLanSmsSendException {
        this.validateProperties();
        this.validateParams(phoneNumbers);
        if (signName.isEmpty()) {
            throw new ChuangLanSmsConfigException(ChuangLanSmsConfigErrorEnum.SIGN_NAME_NOT_CONFIGURED);
        }
        if (message.isEmpty()) {
            throw new ChuangLanSmsConfigException(ChuangLanSmsConfigErrorEnum.SEND_MESSAGE_NOT_CONFIGURED);
        }
        return ChuangLanSmsUtils.send(this.chuangLanSmsProperties.getApiAccount(), this.chuangLanSmsProperties.getApiPassword(), this.chuangLanSmsProperties.getHost(), signName, message, phoneNumbers);
    }

    @Override
    public SendResponse send(String message, String phoneNumbers) throws ChuangLanSmsSendException {
        this.validateProperties();
        this.validateParams(phoneNumbers);
        if (message.isEmpty()) {
            throw new ChuangLanSmsConfigException(ChuangLanSmsConfigErrorEnum.SEND_MESSAGE_NOT_CONFIGURED);
        }
        return ChuangLanSmsUtils.send(this.chuangLanSmsProperties.getApiAccount(), this.chuangLanSmsProperties.getApiPassword(), this.chuangLanSmsProperties.getHost(), this.chuangLanSmsProperties.getDefaultSignName(), message, phoneNumbers);
    }

    @Override
    public SendResponse send(String phoneNumbers) throws ChuangLanSmsSendException {
        this.validateProperties();
        this.validateParams(phoneNumbers);
        return ChuangLanSmsUtils.send(this.chuangLanSmsProperties.getApiAccount(), this.chuangLanSmsProperties.getApiPassword(), this.chuangLanSmsProperties.getHost(), this.chuangLanSmsProperties.getDefaultSignName(), this.chuangLanSmsProperties.getDefaultSignName(), phoneNumbers);
    }

    private void validateProperties() throws ChuangLanSmsConfigException {
        String apiAccount = this.chuangLanSmsProperties.getApiAccount();
        String apiPassword = this.chuangLanSmsProperties.getApiPassword();
        String host = this.chuangLanSmsProperties.getHost();
        if (apiAccount == null || apiAccount.isEmpty()) {
            throw new ChuangLanSmsConfigException(ChuangLanSmsConfigErrorEnum.API_ACCOUNT_NOT_CONFIGURED);
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new ChuangLanSmsConfigException(ChuangLanSmsConfigErrorEnum.API_PASSWORD_NOT_CONFIGURED);
        }
        if (host == null || host.isEmpty()) {
            throw new ChuangLanSmsConfigException(ChuangLanSmsConfigErrorEnum.HOST_NOT_CONFIGURED);
        }
    }

    private void validateParams(String phoneNumbers) throws ChuangLanSmsSendException {
        for (String phoneNumber : phoneNumbers.split(",")) {
            if (ReUtil.isMatch((String)"((\\d{11})|^((\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1})|(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1}))$)", (CharSequence)phoneNumber.replaceFirst("\\+", ""))) continue;
            throw new ChuangLanSmsSendException(ChuangLanSmsSendErrorEnum.MALFORMED_PHONE_NUMBER);
        }
    }
}

