/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.chuanglansms.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import pro.haichuang.framework.sdk.chuanglansms.enums.success.ChuangLanSmsSendSuccessEnum;
import pro.haichuang.framework.sdk.chuanglansms.exception.ChuangLanSmsSendException;
import pro.haichuang.framework.sdk.chuanglansms.response.SendResponse;

public class ChuangLanSmsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChuangLanSmsUtils.class);
    private static final String LOG_TAG = "ChuangLanSms\u5de5\u5177\u7c7b";

    public static SendResponse send(@NonNull String apiAccount, @NonNull String apiPassword, @NonNull String host, @NonNull String signName, @NonNull String message, @NonNull String phoneNumbers) throws ChuangLanSmsSendException {
        String baseUrl = new StringJoiner("", "https://", "/msg/v1/send/json").add(host).toString();
        JSONObject params = new JSONObject();
        params.put("account", (Object)apiAccount);
        params.put("password", (Object)apiPassword);
        params.put("msg", (Object)MessageFormat.format("\u3010{0}\u3011{1}", signName, message));
        params.put("phone", (Object)phoneNumbers);
        String responseJson = HttpUtil.post((String)baseUrl, (String)params.toJSONString());
        SendResponse response = (SendResponse)JSONObject.parseObject((String)responseJson, SendResponse.class);
        if (!ChuangLanSmsSendSuccessEnum.SEND_SUCCESS.value().equals(response.getErrorCode())) {
            LOGGER.error("[{}] \u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25 [errorCode: {}, errorMessage: {}, message: {}, phoneNumbers: {}]", new Object[]{LOG_TAG, response.getErrorCode(), response.getErrorMessage(), message, phoneNumbers});
            throw new ChuangLanSmsSendException(response.getErrorCode(), response.getErrorMessage());
        }
        return response;
    }
}

