/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.huaweicloudobs.config.aspect;

import io.jsonwebtoken.lang.Collections;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import pro.haichuang.framework.base.response.vo.MultiVO;
import pro.haichuang.framework.base.response.vo.PageVO;
import pro.haichuang.framework.base.response.vo.SingleVO;
import pro.haichuang.framework.sdk.huaweicloudobs.annotation.EnableObsUrlConvert;
import pro.haichuang.framework.sdk.huaweicloudobs.annotation.ObsUrl;
import pro.haichuang.framework.sdk.huaweicloudobs.config.properties.HuaWeiCloudObsProperties;

@Aspect
public class ObsUrlAspect {
    @Autowired
    private HuaWeiCloudObsProperties huaWeiCloudObsProperties;

    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object proceed;
        block7: {
            Collection collection;
            block8: {
                block6: {
                    MethodSignature signature = (MethodSignature)point.getSignature();
                    Method method = signature.getMethod();
                    EnableObsUrlConvert enableObsUrlConvert = method.getAnnotation(EnableObsUrlConvert.class);
                    if (enableObsUrlConvert != null) {
                        Object[] args = point.getArgs();
                        Parameter[] parameters = method.getParameters();
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i] == null) continue;
                            if (args[i] instanceof String && parameters[i].getAnnotation(ObsUrl.class) != null) {
                                String tempUrl = (String)args[i];
                                args[i] = tempUrl.replace(this.huaWeiCloudObsProperties.getBucketDomain(), "");
                                continue;
                            }
                            this.obsUrlConvert(args[i], true);
                        }
                    }
                    if (!((proceed = point.proceed()) instanceof SingleVO)) break block6;
                    this.obsUrlConvert(((SingleVO)proceed).getData(), false);
                    break block7;
                }
                if (!(proceed instanceof MultiVO)) break block8;
                collection = ((MultiVO)proceed).getData();
                if (Collections.isEmpty((Collection)collection)) break block7;
                for (Object obj : collection) {
                    this.obsUrlConvert(obj, false);
                }
                break block7;
            }
            if (proceed instanceof PageVO && !Collections.isEmpty((Collection)(collection = ((PageVO)proceed).getData()))) {
                for (Object obj : collection) {
                    this.obsUrlConvert(obj, false);
                }
            }
        }
        return proceed;
    }

    private void obsUrlConvert(Object obj, boolean isRequestObj) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        if (obj != null) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = obj.getClass().getDeclaredFields()) {
                if (declaredField.getAnnotation(ObsUrl.class) == null) continue;
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(declaredField.getName(), obj.getClass());
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                Object originUrl = readMethod.invoke(obj, new Object[0]);
                if (originUrl == null) continue;
                writeMethod.invoke(obj, this.getNewObsUrl(originUrl, isRequestObj));
            }
        }
    }

    private Object getNewObsUrl(Object originObsUrl, boolean isRequestObj) {
        String bucketDomain = this.huaWeiCloudObsProperties.getBucketDomain();
        ArrayList newObsUrl = originObsUrl;
        if (originObsUrl instanceof Collection) {
            Collection originObsUrls = originObsUrl;
            ArrayList newObsUrls = new ArrayList(originObsUrls.size());
            Iterator iterator = originObsUrls.iterator();
            while (iterator.hasNext()) {
                Object tempOriginObsUrl;
                Object tempObsUrl = tempOriginObsUrl = iterator.next();
                if (tempOriginObsUrl instanceof String) {
                    tempObsUrl = isRequestObj ? ((String)tempOriginObsUrl).replace(bucketDomain, "") : bucketDomain + tempOriginObsUrl;
                }
                newObsUrls.add(tempObsUrl);
            }
            newObsUrl = newObsUrls;
        } else if (originObsUrl instanceof String) {
            newObsUrl = isRequestObj ? ((String)((Object)originObsUrl)).replace(bucketDomain, "") : bucketDomain + originObsUrl;
        }
        return newObsUrl;
    }
}

