/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.huaweicloudobs.util;

import com.alibaba.fastjson.JSONObject;
import com.obs.services.ObsClient;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.ObsObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;
import pro.haichuang.framework.base.util.common.FileUriUtils;
import pro.haichuang.framework.sdk.huaweicloudobs.enums.error.HuaWeiCloudObsUploadErrorEnum;
import pro.haichuang.framework.sdk.huaweicloudobs.exception.HuaWeiCloudObsUploadException;

public class HuaWeiCloudObsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HuaWeiCloudObsUtils.class);
    private static final String LOG_TAG = "[sdk-huaweicloudobs] HuaWeiCloudObsUtils\u5de5\u5177\u7c7b";

    public static String uploadByMultipart(MultipartFile uploadFile, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByMultipart(uploadFile, null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByMultipart(MultipartFile uploadFile, @Nullable String newFileName, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        String resultFilePath = HuaWeiCloudObsUtils.baseFileUploadByMultipart(new LinkedList<MultipartFile>(Collections.singletonList(uploadFile)), newFileName != null ? new LinkedList<String>(Collections.singletonList(newFileName)) : null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath).get(0);
        LOGGER.info("[{}] \u7b80\u5355\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, resultFilePath});
        return resultFilePath;
    }

    public static String uploadByPath(String absoluteFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByPath(absoluteFilePath, null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByPath(String absoluteFilePath, @Nullable String newFileName, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByFile(new File(absoluteFilePath), newFileName, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByFile(File uploadFile, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByFile(uploadFile, null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static String uploadByFile(File uploadFile, @Nullable String newFileName, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        String resultFilePath = HuaWeiCloudObsUtils.baseFileUploadByFile(new LinkedList<File>(Collections.singletonList(uploadFile)), newFileName != null ? new LinkedList<String>(Collections.singletonList(newFileName)) : null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath).get(0);
        LOGGER.info("[{}] \u7b80\u5355\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, resultFilePath});
        return resultFilePath;
    }

    public static List<String> uploadByMultipart(Collection<MultipartFile> uploadFiles, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByMultipart(new LinkedList<MultipartFile>(uploadFiles), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> uploadByMultipart(LinkedList<MultipartFile> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        if (uploadFiles.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}]", (Object)LOG_TAG, (Object)bucketName);
            return new ArrayList<String>();
        }
        List<String> resultFilePaths = HuaWeiCloudObsUtils.baseFileUploadByMultipart(uploadFiles, newFileNames, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
        LOGGER.info("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPaths: {}]", new Object[]{LOG_TAG, bucketName, resultFilePaths});
        return resultFilePaths;
    }

    public static List<String> uploadByPath(Collection<String> absoluteFilePaths, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByPath(new LinkedList<String>(absoluteFilePaths), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> uploadByPath(LinkedList<String> absoluteFilePaths, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        if (absoluteFilePaths.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}]", (Object)LOG_TAG, (Object)bucketName);
            return new ArrayList<String>();
        }
        List<String> resultFilePaths = HuaWeiCloudObsUtils.uploadByFile(absoluteFilePaths.stream().map(File::new).collect(LinkedList::new, LinkedList::add, LinkedList::addAll), newFileNames, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
        LOGGER.info("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPaths: {}]", new Object[]{LOG_TAG, bucketName, resultFilePaths});
        return resultFilePaths;
    }

    public static List<String> uploadByFile(Collection<File> uploadFiles, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.uploadByFile(new LinkedList<File>(uploadFiles), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> uploadByFile(LinkedList<File> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        if (uploadFiles.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}]", (Object)LOG_TAG, (Object)bucketName);
            return new ArrayList<String>();
        }
        List<String> resultFilePaths = HuaWeiCloudObsUtils.baseFileUploadByFile(uploadFiles, newFileNames, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
        LOGGER.info("[{}] \u6279\u91cf\u4e0a\u4f20\u6587\u4ef6 [bucketName: {}, resultPaths: {}]", new Object[]{LOG_TAG, bucketName, resultFilePaths});
        return resultFilePaths;
    }

    public static void downloadToResponse(String obsFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HuaWeiCloudObsUtils.downloadToResponse(obsFilePath, accessKeyId, accessKeySecret, bucketName, endPoint, null, request, response);
    }

    public static void downloadToResponse(String obsFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, @Nullable String outFileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MediaType mediaType;
        String fileBaseName = FilenameUtils.getName((String)(outFileName != null && !outFileName.isEmpty() ? outFileName : obsFilePath));
        File file = HuaWeiCloudObsUtils.downloadToFile(obsFilePath, accessKeyId, accessKeySecret, bucketName, endPoint, fileBaseName);
        ServletContext servletContext = request.getServletContext();
        String mineType = servletContext.getMimeType(fileBaseName);
        try {
            mediaType = MediaType.parseMediaType((String)mineType);
        }
        catch (Exception e) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        response.setContentType(mediaType.getType());
        response.setHeader("Content-Disposition", ContentDisposition.attachment().filename(fileBaseName, StandardCharsets.UTF_8).build().toString());
        response.setContentLengthLong(file.length());
        FileUtils.copyFile((File)file, (OutputStream)response.getOutputStream());
    }

    public static File downloadToFile(String obsFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) throws IOException {
        return HuaWeiCloudObsUtils.downloadToFile(obsFilePath, accessKeyId, accessKeySecret, bucketName, endPoint, "");
    }

    public static File downloadToFile(String obsFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, @Nullable String outFileName) throws IOException {
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            obsFilePath = FileUriUtils.formatFilename((String)obsFilePath, (boolean)true);
            String fileBaseName = FilenameUtils.getName((String)(outFileName != null && !outFileName.isEmpty() ? outFileName : obsFilePath));
            File outFile = new File(fileBaseName);
            ObsObject obsObject = obsClient.getObject(bucketName, obsFilePath);
            try (InputStream inputStream = obsObject.getObjectContent();){
                FileUtils.copyToFile((InputStream)inputStream, (File)outFile);
            }
            File file = outFile;
            return file;
        }
    }

    public static File downloadToFile(String obsFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, @Nullable File outFile) throws IOException {
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            obsFilePath = FileUriUtils.formatFilename((String)obsFilePath, (boolean)true);
            outFile = outFile != null ? outFile : new File(obsFilePath);
            ObsObject obsObject = obsClient.getObject(bucketName, obsFilePath);
            try (InputStream inputStream = obsObject.getObjectContent();){
                FileUtils.copyToFile((InputStream)inputStream, (File)outFile);
            }
            File file = outFile;
            return file;
        }
    }

    public static void deleteObject(String obsFilePath, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) throws IOException {
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            obsClient.deleteObject(bucketName, FileUriUtils.formatFilename((String)obsFilePath, (boolean)true));
            LOGGER.info("[{}] \u5220\u9664\u6587\u4ef6 [bucketName: {}, resultPath: {}]", new Object[]{LOG_TAG, bucketName, obsFilePath});
        }
    }

    public static List<DeleteObjectsResult.ErrorResult> deleteObjectResError(Collection<String> obsFilePaths, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) throws IOException {
        if (obsFilePaths.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u5220\u9664\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}]", (Object)LOG_TAG, (Object)bucketName);
            return new ArrayList<DeleteObjectsResult.ErrorResult>();
        }
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
            obsFilePaths.stream().map(path -> FileUriUtils.formatFilename((String)path, (boolean)true)).forEach(arg_0 -> ((DeleteObjectsRequest)deleteObjectsRequest).addKeyAndVersion(arg_0));
            DeleteObjectsResult deleteObjectsResult = obsClient.deleteObjects(deleteObjectsRequest);
            List errorResults = deleteObjectsResult.getErrorResults();
            LOGGER.info("[{}] \u5220\u9664\u6587\u4ef6 [bucketName: {}, errorResults: {}]", new Object[]{LOG_TAG, bucketName, JSONObject.toJSONString((Object)errorResults)});
            List list = errorResults;
            return list;
        }
    }

    public static List<DeleteObjectsResult.DeleteObjectResult> deleteObjectResSuccess(Collection<String> obsFilePaths, String accessKeyId, String accessKeySecret, String bucketName, String endPoint) throws IOException {
        if (obsFilePaths.isEmpty()) {
            LOGGER.warn("[{}] \u6279\u91cf\u5220\u9664\u6587\u4ef6\u4e3a\u7a7a [bucketName: {}]", (Object)LOG_TAG, (Object)bucketName);
            return new ArrayList<DeleteObjectsResult.DeleteObjectResult>();
        }
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
            obsFilePaths.stream().map(path -> FileUriUtils.formatFilename((String)path, (boolean)true)).forEach(arg_0 -> ((DeleteObjectsRequest)deleteObjectsRequest).addKeyAndVersion(arg_0));
            DeleteObjectsResult deleteObjectsResult = obsClient.deleteObjects(deleteObjectsRequest);
            List<DeleteObjectsResult.DeleteObjectResult> successResults = deleteObjectsResult.getDeletedObjectResults().stream().filter(DeleteObjectsResult.DeleteObjectResult::isDeleteMarker).collect(Collectors.toList());
            LOGGER.info("[{}] \u6279\u91cf\u5220\u9664\u6587\u4ef6 [bucketName: {}, successResults: {}]", new Object[]{LOG_TAG, bucketName, JSONObject.toJSONString(successResults)});
            List<DeleteObjectsResult.DeleteObjectResult> list = successResults;
            return list;
        }
    }

    public static List<String> baseFileUploadByMultipart(Collection<MultipartFile> files, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.baseFileUploadByMultipart(new LinkedList<MultipartFile>(files), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> baseFileUploadByMultipart(LinkedList<MultipartFile> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        if (uploadFiles.stream().anyMatch(item -> item == null || item.isEmpty())) {
            throw new HuaWeiCloudObsUploadException(HuaWeiCloudObsUploadErrorEnum.NOT_EXISTS);
        }
        if (newFileNames != null && newFileNames.size() != uploadFiles.size()) {
            throw new HuaWeiCloudObsUploadException(HuaWeiCloudObsUploadErrorEnum.ORIGIN_DATA_AND_FILE_NAME_SIZE_MISMATCH);
        }
        ArrayList<String> resultFilePaths = new ArrayList<String>();
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            for (int i = 0; i < uploadFiles.size(); ++i) {
                String fileRelativeName = FileUriUtils.concatFilename((MultipartFile)uploadFiles.get(i), (String)(newFileNames != null ? newFileNames.get(i) : null), (String)fileType, (String[])uploadPath);
                obsClient.putObject(bucketName, fileRelativeName, uploadFiles.get(i).getInputStream());
                String resultFilePath = FileUriUtils.formatFilename((String)FilenameUtils.concat((String)"/", (String)fileRelativeName), (boolean)false);
                resultFilePaths.add(resultFilePath);
            }
        }
        return resultFilePaths;
    }

    public static List<String> baseFileUploadByFile(Collection<File> uploadFiles, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        return HuaWeiCloudObsUtils.baseFileUploadByFile(new LinkedList<File>(uploadFiles), null, accessKeyId, accessKeySecret, bucketName, endPoint, fileType, uploadPath);
    }

    public static List<String> baseFileUploadByFile(LinkedList<File> uploadFiles, @Nullable LinkedList<String> newFileNames, String accessKeyId, String accessKeySecret, String bucketName, String endPoint, String fileType, String ... uploadPath) throws HuaWeiCloudObsUploadException, IOException {
        if (uploadFiles.stream().anyMatch(item -> item == null || !item.exists())) {
            throw new HuaWeiCloudObsUploadException(HuaWeiCloudObsUploadErrorEnum.NOT_EXISTS);
        }
        if (uploadFiles.stream().anyMatch(item -> !item.isFile())) {
            throw new HuaWeiCloudObsUploadException(HuaWeiCloudObsUploadErrorEnum.NOT_FILE);
        }
        if (newFileNames != null && newFileNames.size() != uploadFiles.size()) {
            throw new HuaWeiCloudObsUploadException(HuaWeiCloudObsUploadErrorEnum.ORIGIN_DATA_AND_FILE_NAME_SIZE_MISMATCH);
        }
        ArrayList<String> resultFilePaths = new ArrayList<String>();
        try (ObsClient obsClient = new ObsClient(accessKeyId, accessKeySecret, endPoint);){
            for (int i = 0; i < uploadFiles.size(); ++i) {
                String fileAbsolutePath = uploadFiles.get(i).getAbsolutePath();
                String fileRelativeName = FileUriUtils.concatFilename((String)fileAbsolutePath, (String)(newFileNames != null ? newFileNames.get(i) : null), (String)fileType, (String[])uploadPath);
                obsClient.putObject(bucketName, fileRelativeName, new File(fileAbsolutePath));
                String resultFilePath = FileUriUtils.formatFilename((String)FilenameUtils.concat((String)"/", (String)fileRelativeName), (boolean)false);
                resultFilePaths.add(resultFilePath);
            }
            ArrayList<String> arrayList = resultFilePaths;
            return arrayList;
        }
    }
}

