/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.huaweicloudobs.service;

import com.obs.services.model.DeleteObjectsResult;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;
import pro.haichuang.framework.base.enums.upload.UploadTypeEnum;
import pro.haichuang.framework.sdk.huaweicloudobs.config.properties.HuaWeiCloudObsProperties;
import pro.haichuang.framework.sdk.huaweicloudobs.enums.error.HuaWeiCloudObsConfigErrorEnum;
import pro.haichuang.framework.sdk.huaweicloudobs.enums.error.HuaWeiCloudObsUploadErrorEnum;
import pro.haichuang.framework.sdk.huaweicloudobs.exception.HuaWeiCloudObsConfigException;
import pro.haichuang.framework.sdk.huaweicloudobs.exception.HuaWeiCloudObsUploadException;
import pro.haichuang.framework.sdk.huaweicloudobs.service.HuaWeiCloudObsService;
import pro.haichuang.framework.sdk.huaweicloudobs.util.HuaWeiCloudObsUtils;

public class DefaultHuaWeiCloudObsServiceImpl
implements HuaWeiCloudObsService {
    private static final String[] DEFAULT_PATH_OF_BIZ_NAME = new String[]{"temp"};
    @Autowired
    private HuaWeiCloudObsProperties huaWeiCloudObsProperties;

    @Override
    public String uploadByMultipart(MultipartFile uploadFile, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByMultipart(uploadFile, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByMultipart(MultipartFile uploadFile, String newFileName, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByMultipart(uploadFile, newFileName, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByMultipart(List<MultipartFile> uploadFiles, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByMultipart(uploadFiles, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByMultipart(LinkedList<MultipartFile> uploadFiles, LinkedList<String> newFileNames, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByMultipart(uploadFiles, newFileNames, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByPath(String absoluteFilePath, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByPath(absoluteFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByPath(String absoluteFilePath, String newFileName, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByPath(absoluteFilePath, newFileName, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByPath(List<String> absoluteFilePaths, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByPath(absoluteFilePaths, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByPath(LinkedList<String> absoluteFilePaths, LinkedList<String> newFileNames, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByPath(absoluteFilePaths, newFileNames, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByFile(File absoluteFilePath, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByFile(absoluteFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public String uploadByFile(File absoluteFilePath, String newFileName, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByFile(absoluteFilePath, newFileName, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByFile(List<File> absoluteFilePaths, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByFile(absoluteFilePaths, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public List<String> uploadByFile(LinkedList<File> absoluteFilePaths, LinkedList<String> newFileNames, UploadTypeEnum uploadTypeEnum, String ... pathOfBizName) {
        this.validateProperties();
        this.validateParams(uploadTypeEnum);
        pathOfBizName = pathOfBizName.length == 0 ? DEFAULT_PATH_OF_BIZ_NAME : pathOfBizName;
        return HuaWeiCloudObsUtils.uploadByFile(absoluteFilePaths, newFileNames, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), uploadTypeEnum.value(), pathOfBizName);
    }

    @Override
    public void downloadToResponse(String ossFilePath, HttpServletRequest request, HttpServletResponse response) {
        this.validateProperties();
        HuaWeiCloudObsUtils.downloadToResponse(ossFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), request, response);
    }

    @Override
    public void downloadToResponse(String ossFilePath, @Nullable String fileName, HttpServletRequest request, HttpServletResponse response) {
        this.validateProperties();
        HuaWeiCloudObsUtils.downloadToResponse(ossFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), fileName, request, response);
    }

    @Override
    public File downloadToFile(String ossFilePath) {
        this.validateProperties();
        return HuaWeiCloudObsUtils.downloadToFile(ossFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint());
    }

    @Override
    public File downloadToFile(String ossFilePath, @Nullable String outFileName) {
        this.validateProperties();
        return HuaWeiCloudObsUtils.downloadToFile(ossFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), outFileName);
    }

    @Override
    public File downloadToFile(String ossFilePath, @Nullable File outFile) {
        this.validateProperties();
        return HuaWeiCloudObsUtils.downloadToFile(ossFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint(), outFile);
    }

    @Override
    public void deleteObjectResSuccess(String ossFilePath) {
        this.validateProperties();
        HuaWeiCloudObsUtils.deleteObject(ossFilePath, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint());
    }

    @Override
    public List<DeleteObjectsResult.DeleteObjectResult> deleteObjectResSuccess(Collection<String> ossFilePaths) {
        this.validateProperties();
        return HuaWeiCloudObsUtils.deleteObjectResSuccess(ossFilePaths, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint());
    }

    @Override
    public List<DeleteObjectsResult.ErrorResult> deleteObjectResError(Collection<String> ossFilePaths) {
        this.validateProperties();
        return HuaWeiCloudObsUtils.deleteObjectResError(ossFilePaths, this.huaWeiCloudObsProperties.getAccessKeyId(), this.huaWeiCloudObsProperties.getAccessKeySecret(), this.huaWeiCloudObsProperties.getBucketName(), this.huaWeiCloudObsProperties.getEndpoint());
    }

    private void validateProperties() {
        String accessKeyId = this.huaWeiCloudObsProperties.getAccessKeyId();
        String accessKeySecret = this.huaWeiCloudObsProperties.getAccessKeySecret();
        String bucketName = this.huaWeiCloudObsProperties.getBucketName();
        String endpoint = this.huaWeiCloudObsProperties.getEndpoint();
        if (accessKeyId == null || accessKeyId.isEmpty()) {
            throw new HuaWeiCloudObsConfigException(HuaWeiCloudObsConfigErrorEnum.ACCESS_KEY_ID_NOT_CONFIGURED);
        }
        if (accessKeySecret == null || accessKeySecret.isEmpty()) {
            throw new HuaWeiCloudObsConfigException(HuaWeiCloudObsConfigErrorEnum.ACCESS_KEY_SECRET_NOT_CONFIGURED);
        }
        if (bucketName == null || bucketName.isEmpty()) {
            throw new HuaWeiCloudObsConfigException(HuaWeiCloudObsConfigErrorEnum.BUCKET_NAME_NOT_CONFIGURED);
        }
        if (endpoint == null || endpoint.isEmpty()) {
            throw new HuaWeiCloudObsConfigException(HuaWeiCloudObsConfigErrorEnum.END_POINT_NOT_CONFIGURED);
        }
    }

    private void validateParams(@Nullable UploadTypeEnum uploadTypeEnum) {
        if (uploadTypeEnum == null) {
            throw new HuaWeiCloudObsUploadException(HuaWeiCloudObsUploadErrorEnum.UPLOAD_FILE_TYPE_IS_NULL);
        }
    }
}

