/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.huaweicloudsms.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import pro.haichuang.framework.base.enums.BaseEnum;
import pro.haichuang.framework.base.exception.ThirdPartyException;
import pro.haichuang.framework.base.util.common.UUIDUtils;
import pro.haichuang.framework.sdk.huaweicloudsms.response.SendResponse;

public class HuaWeiCloudSmsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HuaWeiCloudSmsUtils.class);
    private static final String LOG_TAG = "sdk-huaweicloudsms-util";
    private static final String SUCCESS_CODE = "000000";

    public static void main(String[] args) {
        List<SendResponse.Result> data = HuaWeiCloudSmsUtils.send("https://rtcsms.cn-north-1.myhuaweicloud.com:10743", "2d60t967IL3c6EU6bm3gTzI4z478", "6j7F1Yx4843LsUXnvcufU1K40Wwn", "\u4e2d\u9e3f\u5546\u4e1a\u4fdd\u7406", "8821081732829", "15181743604", "9f39c42b030e403faabbf30f25fdd1ab", new JSONArray().fluentAdd((Object)String.valueOf(RandomUtils.nextInt((int)100000, (int)1000000))));
        System.out.println(data);
    }

    public static List<SendResponse.Result> send(String url, String appKey, String appSecret, String signName, String channelNumber, String phoneNumbers, String templateId, @Nullable JSONArray templateParams) throws ThirdPartyException {
        String baseUrl = url + "/sms/batchSendSms/v1";
        String contentTypeHeader = "application/x-www-form-urlencoded";
        String authorizationHeader = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
        String xWsseHeader = HuaWeiCloudSmsUtils.buildWsseHeader(appKey, appSecret);
        JSONObject params = new JSONObject();
        params.put("from", (Object)channelNumber);
        params.put("to", (Object)phoneNumbers);
        params.put("templateId", (Object)templateId);
        if (templateParams != null && templateParams.size() != 0) {
            params.put("templateParas", (Object)templateParams.toJSONString());
        }
        params.put("signature", (Object)signName);
        String fullUrl = HttpUtil.urlWithForm((String)baseUrl, (Map)params.getInnerMap(), (Charset)StandardCharsets.UTF_8, (boolean)true);
        String responseJson = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)fullUrl).header("Content-Type", contentTypeHeader)).header("Authorization", authorizationHeader)).header("X-WSSE", xWsseHeader)).execute().body();
        SendResponse response = (SendResponse)JSONObject.parseObject((String)responseJson, SendResponse.class);
        if (!SUCCESS_CODE.equals(response.getErrorCode())) {
            LOGGER.error("[{}] \u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25 [errorCode: {}, errorMessage: {}, phoneNumbers: {}, templateId: {}, templateParams: {}]", new Object[]{LOG_TAG, response.getErrorCode(), response.getErrorMessage(), phoneNumbers, templateId, templateParams});
            throw new ThirdPartyException(response.getErrorCode(), response.getErrorMessage());
        }
        for (SendResponse.Result result : response.getContent()) {
            if (SUCCESS_CODE.equals((Object)result.getStatus())) continue;
            LOGGER.error("[{}] \u53d1\u9001\u9a8c\u8bc1\u7801\u72b6\u6001\u9519\u8bef [errorStatus: {}, phoneNumbers: {}, templateId: {}, templateParams: {}]", new Object[]{LOG_TAG, result.getStatus(), phoneNumbers, templateId, templateParams});
            throw new ThirdPartyException((BaseEnum)result.getStatus(), "\u53d1\u9001\u9a8c\u8bc1\u7801\u72b6\u6001\u9519\u8bef");
        }
        return response.getContent();
    }

    public static String buildWsseHeader(String appKey, String appSecret) {
        String time = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").format(LocalDateTime.now());
        String nonce = UUIDUtils.random();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update((nonce + time + appSecret).getBytes());
        byte[] passwordDigest = md.digest();
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(passwordDigest);
        return String.format("UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"", appKey, passwordDigestBase64Str, nonce, time);
    }
}

