/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.huaweicloudsms.service;

import cn.hutool.core.util.ReUtil;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import pro.haichuang.framework.sdk.huaweicloudsms.config.properties.HuaWeiCloudSmsProperties;
import pro.haichuang.framework.sdk.huaweicloudsms.enums.error.HuaWeiCloudSmsConfigErrorEnum;
import pro.haichuang.framework.sdk.huaweicloudsms.enums.error.HuaWeiCloudSmsSendErrorEnum;
import pro.haichuang.framework.sdk.huaweicloudsms.exception.HuaWeiCloudSmsConfigException;
import pro.haichuang.framework.sdk.huaweicloudsms.exception.HuaWeiCloudSmsSendException;
import pro.haichuang.framework.sdk.huaweicloudsms.response.SendResponse;
import pro.haichuang.framework.sdk.huaweicloudsms.service.HuaWeiCloudSmsService;
import pro.haichuang.framework.sdk.huaweicloudsms.util.HuaWeiCloudSmsUtils;

public class DefaultHuaWeiCloudSmsServiceImpl
implements HuaWeiCloudSmsService {
    @Autowired
    private HuaWeiCloudSmsProperties huaWeiCloudSmsProperties;

    @Override
    public List<SendResponse.Result> send(String signName, String channelNumber, String templateId, String phoneNumbers, @Nullable JSONArray templateParams) {
        this.validateProperties();
        this.validateParams(phoneNumbers);
        if (signName.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.SIGN_NAME_NOT_CONFIGURED);
        }
        if (channelNumber.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.CHANNEL_NUMBER_NOT_CONFIGURED);
        }
        if (templateId.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.TEMPLATE_ID_NOT_CONFIGURED);
        }
        return HuaWeiCloudSmsUtils.send(this.huaWeiCloudSmsProperties.getAppUrl(), this.huaWeiCloudSmsProperties.getAppKey(), this.huaWeiCloudSmsProperties.getAppSecret(), signName, channelNumber, phoneNumbers, templateId, templateParams);
    }

    @Override
    public List<SendResponse.Result> send(String templateId, String phoneNumbers, @Nullable JSONArray templateParams) {
        this.validateProperties();
        this.validateParams(phoneNumbers);
        if (templateId.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.TEMPLATE_ID_NOT_CONFIGURED);
        }
        return HuaWeiCloudSmsUtils.send(this.huaWeiCloudSmsProperties.getAppUrl(), this.huaWeiCloudSmsProperties.getAppKey(), this.huaWeiCloudSmsProperties.getAppSecret(), this.huaWeiCloudSmsProperties.getDefaultSignName(), this.huaWeiCloudSmsProperties.getDefaultChannelNumber(), phoneNumbers, templateId, templateParams);
    }

    @Override
    public List<SendResponse.Result> send(String phoneNumbers, @Nullable JSONArray templateParams) {
        this.validateProperties();
        this.validateParams(phoneNumbers);
        return HuaWeiCloudSmsUtils.send(this.huaWeiCloudSmsProperties.getAppUrl(), this.huaWeiCloudSmsProperties.getAppKey(), this.huaWeiCloudSmsProperties.getAppSecret(), this.huaWeiCloudSmsProperties.getDefaultSignName(), this.huaWeiCloudSmsProperties.getDefaultChannelNumber(), phoneNumbers, this.huaWeiCloudSmsProperties.getDefaultTemplateId(), templateParams);
    }

    private void validateProperties() {
        String appKey = this.huaWeiCloudSmsProperties.getAppKey();
        String appSecret = this.huaWeiCloudSmsProperties.getAppSecret();
        String appUrl = this.huaWeiCloudSmsProperties.getAppUrl();
        if (appKey == null || appKey.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.APP_KEY_NOT_CONFIGURED);
        }
        if (appSecret == null || appSecret.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.APP_SECRET_NOT_CONFIGURED);
        }
        if (appUrl == null || appUrl.isEmpty()) {
            throw new HuaWeiCloudSmsConfigException(HuaWeiCloudSmsConfigErrorEnum.APP_URL_NOT_CONFIGURED);
        }
    }

    private void validateParams(String phoneNumbers) {
        for (String phoneNumber : phoneNumbers.split(",")) {
            if (ReUtil.isMatch((String)"((\\d{11})|^((\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1})|(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1}))$)", (CharSequence)phoneNumber.replaceFirst("\\+", ""))) continue;
            throw new HuaWeiCloudSmsSendException(HuaWeiCloudSmsSendErrorEnum.MALFORMED_PHONE_NUMBER);
        }
    }
}

