/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.wxmp.store;

import java.time.Duration;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.haichuang.framework.redis.service.RedisService;
import pro.haichuang.framework.sdk.wxmp.key.WxMpKey;
import pro.haichuang.framework.sdk.wxmp.store.WxMpDataStore;

public class WxMpRedisDataStore
implements WxMpDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxMpRedisDataStore.class);
    private static final String LOG_TAG = "WxMpDataStoreRedis\u5b9e\u73b0";
    @Autowired
    private RedisService redisService;

    @Override
    public void setBaseAccessToken(String key, String baseAccessToken, Duration expireTime) {
        this.redisService.set(key, (Object)baseAccessToken, expireTime.getSeconds());
    }

    @Override
    public String getBaseAccessToken(String key) {
        return (String)this.redisService.get(key);
    }

    @Override
    public void setWebAccessToken(String key, String webAccessToken, Duration expireTime) {
        this.redisService.set(key, (Object)webAccessToken, expireTime.getSeconds());
    }

    @Override
    public String getWebAccessToken(String key) {
        return (String)this.redisService.get(key);
    }

    @Override
    public void setWebRefreshAccessToken(String key, String webRefreshAccessToken, Duration expireTime) {
        this.redisService.set(key, (Object)webRefreshAccessToken, expireTime.getSeconds());
    }

    @Override
    public String getWebRefreshAccessToken(String key) {
        return (String)this.redisService.get(key);
    }

    @Override
    public void setJsApiTicket(String key, String jsApiTicket, Duration expireTime) {
        this.redisService.set(key, (Object)jsApiTicket, expireTime.getSeconds());
    }

    @Override
    public String getJsApiTicket(String key) {
        return (String)this.redisService.get(key);
    }

    @Override
    public void printAllData() {
        LOGGER.info("[{}] ==================== \u5f00\u59cb\u8fdb\u884c\u6570\u636e\u6253\u5370 ====================", (Object)LOG_TAG);
        int baseAccessTokenIndex = 0;
        Set baseAccessTokenRedisKeys = this.redisService.keys(WxMpKey.baseAccessToken());
        if (baseAccessTokenRedisKeys != null) {
            for (String baseAccessTokenRedisKey : baseAccessTokenRedisKeys) {
                String baseAccessToken = (String)this.redisService.get(baseAccessTokenRedisKey);
                long baseAccessTokenExpire = this.redisService.getExpire(baseAccessTokenRedisKey);
                LOGGER.info("[{}] \u6253\u5370BaseAccessToken\u6570\u636e [index: {}, Key: {}, lastExpireTime: {}s, value: {}]", new Object[]{LOG_TAG, baseAccessTokenIndex++, baseAccessTokenRedisKey, baseAccessTokenExpire, baseAccessToken});
            }
        }
        int webAccessTokenIndex = 0;
        Set webAccessTokenRedisKeys = this.redisService.keys(WxMpKey.webAccessToken(""));
        if (webAccessTokenRedisKeys != null) {
            for (String webAccessTokenRedisKey : webAccessTokenRedisKeys) {
                String webAccessToken = (String)this.redisService.get(webAccessTokenRedisKey);
                long webAccessTokenExpire = this.redisService.getExpire(webAccessTokenRedisKey);
                LOGGER.info("[{}] \u6253\u5370WebAccessToken\u6570\u636e [index: {}, Key: {}, lastExpireTime: {}s, value: {}]", new Object[]{LOG_TAG, webAccessTokenIndex++, webAccessTokenRedisKey, webAccessTokenExpire, webAccessToken});
            }
        }
        int webRefreshAccessTokenIndex = 0;
        Set webRefreshAccessTokenRedisKeys = this.redisService.keys(WxMpKey.webRefreshAccessToken(""));
        if (webRefreshAccessTokenRedisKeys != null) {
            for (String webRefreshAccessTokenRedisKey : webRefreshAccessTokenRedisKeys) {
                String webRefreshAccessToken = (String)this.redisService.get(webRefreshAccessTokenRedisKey);
                long webRefreshAccessTokenExpire = this.redisService.getExpire(webRefreshAccessTokenRedisKey);
                LOGGER.info("[{}] \u6253\u5370WebRefreshAccessToken\u6570\u636e [index: {}, Key: {}, lastExpireTime: {}s, value: {}]", new Object[]{LOG_TAG, webRefreshAccessTokenIndex++, webRefreshAccessTokenRedisKey, webRefreshAccessTokenExpire, webRefreshAccessToken});
            }
        }
        int jsApiTicketIndex = 0;
        Set jsApiTicketRedisKeys = this.redisService.keys(WxMpKey.jsApiTicket());
        if (jsApiTicketRedisKeys != null) {
            for (String jsApiTicketRedisKey : jsApiTicketRedisKeys) {
                String jsApiTicket = (String)this.redisService.get(jsApiTicketRedisKey);
                long jsApiTicketExpire = this.redisService.getExpire(jsApiTicketRedisKey);
                LOGGER.info("[{}] \u6253\u5370JsApiTicketMap\u6570\u636e [index: {}, Key: {}, lastExpireTime: {}s, value: {}]", new Object[]{LOG_TAG, jsApiTicketIndex++, jsApiTicketRedisKey, jsApiTicketExpire, jsApiTicket});
            }
        }
        LOGGER.info("[{}] ==================== \u7ed3\u675f\u6253\u5370 ====================", (Object)LOG_TAG);
    }
}

