/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.wxmp.store;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.lang.NonNull;
import pro.haichuang.framework.sdk.wxmp.enums.error.WxMpDelayQueueErrorEnum;
import pro.haichuang.framework.sdk.wxmp.exception.WxMpDelayQueueException;
import pro.haichuang.framework.sdk.wxmp.store.WxMpDataStore;

public class DefaultWxMpDataStore
implements WxMpDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWxMpDataStore.class);
    private static final String LOG_TAG = "WxMpDataStore\u9ed8\u8ba4\u5b9e\u73b0";
    private static final Map<String, String> BASE_ACCESS_TOKEN_MAP = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> WEB_ACCESS_TOKEN_MAP = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> WEB_REFRESH_ACCESS_TOKEN_MAP = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> JS_API_TICKET_MAP = new ConcurrentHashMap<String, String>();
    private static final DelayQueue<DelayBase> DELAY_QUEUE = new DelayQueue();
    private static boolean DELAY_IS_ERROR = true;

    @Override
    public void setBaseAccessToken(@NonNull String key, @NonNull String baseAccessToken, @NonNull Duration expireTime) {
        this.validateDelayError();
        BASE_ACCESS_TOKEN_MAP.put(key, baseAccessToken);
        DELAY_QUEUE.removeIf(delayBase -> ((DelayBase)delayBase).key.equals(key));
        DELAY_QUEUE.put(new DelayBase(DelayDataType.BASE_ACCESS_TOKEN, key, expireTime));
    }

    @Override
    public String getBaseAccessToken(@NonNull String key) {
        this.validateDelayError();
        return BASE_ACCESS_TOKEN_MAP.get(key);
    }

    @Override
    public void setWebAccessToken(@NonNull String key, @NonNull String webAccessToken, @NonNull Duration expireTime) {
        this.validateDelayError();
        WEB_ACCESS_TOKEN_MAP.put(key, webAccessToken);
        DELAY_QUEUE.removeIf(delayBase -> ((DelayBase)delayBase).key.equals(key));
        DELAY_QUEUE.put(new DelayBase(DelayDataType.WEB_ACCESS_TOKEN, key, expireTime));
    }

    @Override
    public String getWebAccessToken(@NonNull String key) {
        this.validateDelayError();
        return WEB_ACCESS_TOKEN_MAP.get(key);
    }

    @Override
    public void setWebRefreshAccessToken(@NonNull String key, @NonNull String webRefreshAccessToken, @NonNull Duration expireTime) {
        this.validateDelayError();
        WEB_REFRESH_ACCESS_TOKEN_MAP.put(key, webRefreshAccessToken);
        DELAY_QUEUE.removeIf(delayBase -> ((DelayBase)delayBase).key.equals(key));
        DELAY_QUEUE.put(new DelayBase(DelayDataType.WEB_REFRESH_ACCESS_TOKEN, key, expireTime));
    }

    @Override
    public String getWebRefreshAccessToken(@NonNull String key) {
        this.validateDelayError();
        return WEB_REFRESH_ACCESS_TOKEN_MAP.get(key);
    }

    @Override
    public void setJsApiTicket(@NonNull String key, @NonNull String jsApiTicket, @NonNull Duration expireTime) {
        this.validateDelayError();
        JS_API_TICKET_MAP.put(key, jsApiTicket);
        DELAY_QUEUE.removeIf(delayBase -> ((DelayBase)delayBase).key.equals(key));
        DELAY_QUEUE.put(new DelayBase(DelayDataType.JS_API_TICKET, key, expireTime));
    }

    @Override
    public String getJsApiTicket(@NonNull String key) {
        this.validateDelayError();
        return JS_API_TICKET_MAP.get(key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printAllData() {
        this.validateDelayError();
        LOGGER.info("[{}] ==================== \u5f00\u59cb\u8fdb\u884c\u6570\u636e\u6253\u5370 ====================", (Object)LOG_TAG);
        int baseAccessTokenMapIndex = 0;
        for (Map.Entry<String, String> entry : BASE_ACCESS_TOKEN_MAP.entrySet()) {
            LOGGER.info("[{}] \u6253\u5370BaseAccessToken\u6570\u636e [index: {}, Key: {}, value: {}]", new Object[]{LOG_TAG, baseAccessTokenMapIndex++, entry.getKey(), entry.getValue()});
        }
        int webAccessTokenMapIndex = 0;
        for (Map.Entry<String, String> entry : WEB_ACCESS_TOKEN_MAP.entrySet()) {
            LOGGER.info("[{}] \u6253\u5370WebAccessToken\u6570\u636e [index: {}, Key: {}, value: {}]", new Object[]{LOG_TAG, webAccessTokenMapIndex++, entry.getKey(), entry.getValue()});
        }
        boolean bl = false;
        for (Map.Entry<String, String> entry : WEB_REFRESH_ACCESS_TOKEN_MAP.entrySet()) {
            void var3_7;
            LOGGER.info("[{}] \u6253\u5370WebRefreshAccessToken\u6570\u636e [index: {}, Key: {}, value: {}]", new Object[]{LOG_TAG, (int)(++var3_7), entry.getKey(), entry.getValue()});
        }
        boolean bl2 = false;
        for (Map.Entry<String, String> entry : JS_API_TICKET_MAP.entrySet()) {
            void var4_11;
            LOGGER.info("[{}] \u6253\u5370JsApiTicketMap\u6570\u636e [index: {}, Key: {}, value: {}]", new Object[]{LOG_TAG, (int)(++var4_11), entry.getKey(), entry.getValue()});
        }
        LOGGER.info("[{}] ==================== \u5f00\u59cb\u8fdb\u884c\u5ef6\u65f6\u961f\u5217\u6253\u5370 ====================", (Object)LOG_TAG);
        boolean bl3 = false;
        for (DelayBase delayBase : DELAY_QUEUE) {
            void var5_15;
            LOGGER.info("[{}] \u6253\u5370DelayQueue\u6570\u636e [index: {}, dataType: {}, Key: {}, lastExpireTime: {}ms]", new Object[]{LOG_TAG, (int)(++var5_15), delayBase.dataType, delayBase.key, delayBase.expireMillis - System.currentTimeMillis()});
        }
        LOGGER.info("[{}] ==================== \u7ed3\u675f\u6253\u5370 ====================", (Object)LOG_TAG);
    }

    private void validateDelayError() {
        if (DELAY_IS_ERROR) {
            throw new WxMpDelayQueueException(WxMpDelayQueueErrorEnum.TERMINATION_ERROR);
        }
    }

    static enum DelayDataType {
        BASE_ACCESS_TOKEN,
        WEB_ACCESS_TOKEN,
        WEB_REFRESH_ACCESS_TOKEN,
        JS_API_TICKET;

    }

    static class DelayBase
    implements Delayed {
        private final DelayDataType dataType;
        private final String key;
        private final long expireMillis;

        public DelayBase(DelayDataType dataType, String key, Duration duration) {
            this.dataType = dataType;
            this.key = key;
            this.expireMillis = System.currentTimeMillis() + duration.toMillis();
        }

        @Override
        public long getDelay(@NonNull TimeUnit unit) {
            return this.expireMillis - System.currentTimeMillis();
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.SECONDS));
        }
    }

    public static class DelayQueueManager
    implements CommandLineRunner {
        public void run(String ... args) {
            try {
                DELAY_IS_ERROR = false;
                while (true) {
                    DelayBase take = (DelayBase)DELAY_QUEUE.take();
                    switch (take.dataType) {
                        case BASE_ACCESS_TOKEN: {
                            LOGGER.info("[{}] \u5f00\u59cb\u9500\u6bc1BaseAccessToken [key: {}, value: {}]", new Object[]{DefaultWxMpDataStore.LOG_TAG, take.key, BASE_ACCESS_TOKEN_MAP.get(take.key)});
                            BASE_ACCESS_TOKEN_MAP.remove(take.key);
                            break;
                        }
                        case WEB_ACCESS_TOKEN: {
                            LOGGER.info("[{}] \u5f00\u59cb\u9500\u6bc1WebAccessToken [key: {}, value: {}]", new Object[]{DefaultWxMpDataStore.LOG_TAG, take.key, WEB_ACCESS_TOKEN_MAP.get(take.key)});
                            WEB_ACCESS_TOKEN_MAP.remove(take.key);
                            break;
                        }
                        case WEB_REFRESH_ACCESS_TOKEN: {
                            LOGGER.info("[{}] \u5f00\u59cb\u9500\u6bc1WebRefreshAccessToken [key: {}, value: {}]", new Object[]{DefaultWxMpDataStore.LOG_TAG, take.key, WEB_REFRESH_ACCESS_TOKEN_MAP.get(take.key)});
                            WEB_REFRESH_ACCESS_TOKEN_MAP.remove(take.key);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                DELAY_IS_ERROR = true;
                LOGGER.error("[{}] \u6267\u884c\u5ef6\u65f6\u961f\u5217\u5931\u8d25", (Object)DefaultWxMpDataStore.LOG_TAG, (Object)e);
                throw new WxMpDelayQueueException(WxMpDelayQueueErrorEnum.UNKNOWN_ERROR);
            }
        }
    }
}

