/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.wxmp.util;

import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import pro.haichuang.framework.base.enums.base.SexEnum;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpBaseAccessTokenDTO;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpJsApiTicketDTO;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpUserInfoDTO;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpWebAccessTokenDTO;
import pro.haichuang.framework.sdk.wxmp.exception.WxMpExecuteException;

public class WxMpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxMpUtils.class);
    private static final String LOG_TAG = "sdk-wxmp-util";
    public static final String ERROR_CODE_NAME = "errcode";
    public static final String ERROR_MESSAGE_NAME = "errmsg";
    private static final Duration WEB_REFRESH_TOKEN_EXPIRE = Duration.ofDays(30L).minusDays(1L);

    public static boolean checkSignature(@NonNull String token, @NonNull String signature, @NonNull String timestamp, @NonNull String nonce) {
        Object[] arr = new String[]{token, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (Object c : arr) {
            content.append((String)c);
        }
        String hexString = DigestUtils.sha1Hex((byte[])content.toString().getBytes());
        return !hexString.isEmpty() && hexString.equals(signature);
    }

    @NonNull
    public static WxMpBaseAccessTokenDTO getBaseAccessToken(@NonNull String appId, @NonNull String appSecret) throws WxMpExecuteException {
        return WxMpUtils.getBaseAccessToken(appId, appSecret, HttpGlobalConfig.getTimeout());
    }

    @NonNull
    public static WxMpBaseAccessTokenDTO getBaseAccessToken(@NonNull String appId, @NonNull String appSecret, int timout) throws WxMpExecuteException {
        String baseUrl = "https://api.weixin.qq.com/cgi-bin/token";
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("appid", appId);
        params.put("secret", appSecret);
        params.put("grant_type", "client_credential");
        JSONObject resultJson = JSONObject.parseObject((String)HttpUtil.get((String)baseUrl, params, (int)timout));
        if (WxMpUtils.validateFailResult(resultJson)) {
            LOGGER.error("[{}] \u83b7\u53d6\u57fa\u7840AccessToken\u5f02\u5e38 [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
            throw new WxMpExecuteException(resultJson.getString(ERROR_CODE_NAME), resultJson.getString(ERROR_MESSAGE_NAME));
        }
        LOGGER.info("[{}] \u6210\u529f\u83b7\u53d6\u57fa\u7840AccessToken [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
        Duration expiresIn = Duration.ofSeconds(resultJson.getLongValue("expires_in"));
        expiresIn = expiresIn.minusMinutes(5L);
        return new WxMpBaseAccessTokenDTO().setAccessToken(resultJson.getString("access_token")).setAccessTokenExpireTime(expiresIn);
    }

    @NonNull
    public static WxMpWebAccessTokenDTO getWebAccessToken(@NonNull String appId, @NonNull String appSecret, @NonNull String code) throws WxMpExecuteException {
        return WxMpUtils.getWebAccessToken(appId, appSecret, code, HttpGlobalConfig.getTimeout());
    }

    @NonNull
    public static WxMpWebAccessTokenDTO getWebAccessToken(@NonNull String appId, @NonNull String appSecret, @NonNull String code, int timout) throws WxMpExecuteException {
        String baseUrl = "https://api.weixin.qq.com/sns/oauth2/access_token";
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("appid", appId);
        params.put("secret", appSecret);
        params.put("code", code);
        params.put("grant_type", "authorization_code");
        JSONObject resultJson = JSONObject.parseObject((String)HttpUtil.get((String)baseUrl, params, (int)timout));
        if (WxMpUtils.validateFailResult(resultJson)) {
            LOGGER.error("[{}] \u83b7\u53d6\u7f51\u9875AccessToken\u5f02\u5e38 [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
            throw new WxMpExecuteException(resultJson.getString(ERROR_CODE_NAME), resultJson.getString(ERROR_MESSAGE_NAME));
        }
        LOGGER.info("[{}] \u6210\u529f\u83b7\u53d6\u7f51\u9875AccessToken [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
        Duration expiresIn = Duration.ofSeconds(resultJson.getLongValue("expires_in"));
        expiresIn = expiresIn.minusMinutes(5L);
        return new WxMpWebAccessTokenDTO().setWebAccessToken(resultJson.getString("access_token")).setWebAccessTokenExpireTime(expiresIn).setWebRefreshToken(resultJson.getString("refresh_token")).setWebRefreshTokenExpireTime(WEB_REFRESH_TOKEN_EXPIRE).setOpenId(resultJson.getString("openid"));
    }

    @NonNull
    public static WxMpWebAccessTokenDTO refreshWebAccessToken(@NonNull String appId, @NonNull String refreshToken) throws WxMpExecuteException {
        return WxMpUtils.refreshWebAccessToken(appId, refreshToken, HttpGlobalConfig.getTimeout());
    }

    @NonNull
    public static WxMpWebAccessTokenDTO refreshWebAccessToken(@NonNull String appId, @NonNull String refreshToken, int timout) throws WxMpExecuteException {
        String baseUrl = "https://api.weixin.qq.com/sns/oauth2/refresh_token";
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("appid", appId);
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", refreshToken);
        JSONObject resultJson = JSONObject.parseObject((String)HttpUtil.get((String)baseUrl, params, (int)timout));
        if (WxMpUtils.validateFailResult(resultJson)) {
            LOGGER.error("[{}] \u5237\u65b0\u7f51\u9875AccessToken\u5f02\u5e38 [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
            throw new WxMpExecuteException(resultJson.getString(ERROR_CODE_NAME), resultJson.getString(ERROR_MESSAGE_NAME));
        }
        LOGGER.info("[{}] \u6210\u529f\u5237\u65b0\u7f51\u9875AccessToken [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
        Duration expiresIn = Duration.ofSeconds(resultJson.getLongValue("expires_in"));
        expiresIn = expiresIn.minusMinutes(5L);
        return new WxMpWebAccessTokenDTO().setWebAccessToken(resultJson.getString("access_token")).setWebAccessTokenExpireTime(expiresIn).setWebRefreshToken(resultJson.getString("refresh_token")).setWebRefreshTokenExpireTime(WEB_REFRESH_TOKEN_EXPIRE).setOpenId(resultJson.getString("openid"));
    }

    @NonNull
    public static WxMpJsApiTicketDTO getJsApiTicket(@NonNull String accessToken) throws WxMpExecuteException {
        return WxMpUtils.getJsApiTicket(accessToken, HttpGlobalConfig.getTimeout());
    }

    @NonNull
    public static WxMpJsApiTicketDTO getJsApiTicket(@NonNull String accessToken, int timout) throws WxMpExecuteException {
        String baseUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("access_token", accessToken);
        params.put("type", "jsapi");
        JSONObject resultJson = JSONObject.parseObject((String)HttpUtil.get((String)baseUrl, params, (int)timout));
        if (WxMpUtils.validateFailResult(resultJson)) {
            LOGGER.error("[{}] \u83b7\u53d6jsApi_ticket\u5f02\u5e38 [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
            throw new WxMpExecuteException(resultJson.getString(ERROR_CODE_NAME), resultJson.getString(ERROR_MESSAGE_NAME));
        }
        LOGGER.info("[{}] \u6210\u529f\u83b7\u53d6jsApi_ticket [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
        Duration expiresIn = Duration.ofSeconds(resultJson.getLongValue("expires_in"));
        expiresIn = expiresIn.minusMinutes(5L);
        return new WxMpJsApiTicketDTO().setTicket(resultJson.getString("ticket")).setEffectiveTime(expiresIn);
    }

    @Nullable
    public static WxMpUserInfoDTO getUserInfo(@NonNull String accessToken, @NonNull String openId) throws WxMpExecuteException {
        String baseUrl = "https://api.weixin.qq.com/cgi-bin/user/info";
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("access_token", accessToken);
        params.put("openid", openId);
        params.put("lang", "zh_CN");
        JSONObject resultJson = JSONObject.parseObject((String)HttpUtil.get((String)baseUrl, params));
        if (WxMpUtils.validateFailResult(resultJson)) {
            LOGGER.error("[{}] \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38 [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
            throw new WxMpExecuteException(resultJson.getString(ERROR_CODE_NAME), resultJson.getString(ERROR_MESSAGE_NAME));
        }
        LOGGER.info("[{}] \u6210\u529f\u83b7\u53d6\u83b7\u53d6\u7528\u6237\u4fe1\u606f [response: {}]", (Object)LOG_TAG, (Object)resultJson.toJSONString());
        if (resultJson.getIntValue("subscribe") == 0) {
            LOGGER.warn("[{}] \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25-\u8be5\u7528\u6237\u672a\u5173\u6ce8\u6b64\u516c\u4f17\u53f7 [openId: {}, response: {}]", new Object[]{LOG_TAG, openId, resultJson.toJSONString()});
            return null;
        }
        return new WxMpUserInfoDTO().setSubscribe(resultJson.getInteger("subscribe")).setOpenId(resultJson.getString("openid")).setNickname(resultJson.getString("nickname")).setSex(resultJson.getIntValue("sex") == 1 ? SexEnum.MAN : (resultJson.getIntValue("sex") == 2 ? SexEnum.WOMAN : SexEnum.UNKNOWN)).setCity(resultJson.getString("city")).setCountry(resultJson.getString("country")).setProvince(resultJson.getString("province")).setLanguage(resultJson.getString("language")).setHeadImageUrl(resultJson.getString("headimgurl")).setSubscribeTime(resultJson.getLong("subscribe_time")).setUnionId(resultJson.getString("unionid")).setRemark(resultJson.getString("remark")).setGroupId(resultJson.getInteger("groupid")).setTagIdList(resultJson.getJSONArray("tagid_list").toJavaList(Integer.class)).setSubscribeScene(WxMpUserInfoDTO.SubscribeSceneEnum.resolve(resultJson.getString("subscribe_scene"))).setQrScene(resultJson.getInteger("qr_scene")).setQrSceneStr(resultJson.getString("qr_scene_str"));
    }

    public static boolean validateFailResult(@NonNull JSONObject jsonObject) {
        Integer errorCode = jsonObject.getInteger(ERROR_CODE_NAME);
        String errorMessage = jsonObject.getString(ERROR_MESSAGE_NAME);
        return ObjectUtils.anyNotNull((Object[])new Object[]{errorCode, errorMessage}) && !errorCode.equals(0);
    }
}

