/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.sdk.wxmp.service;

import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import pro.haichuang.framework.base.enums.BaseEnum;
import pro.haichuang.framework.base.enums.error.client.AuthorityErrorEnum;
import pro.haichuang.framework.base.response.ResultVO;
import pro.haichuang.framework.base.util.common.ResponseUtils;
import pro.haichuang.framework.sdk.wxmp.config.properties.WxMpProperties;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpBaseAccessTokenDTO;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpJsApiTicketDTO;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpUserInfoDTO;
import pro.haichuang.framework.sdk.wxmp.dto.WxMpWebAccessTokenDTO;
import pro.haichuang.framework.sdk.wxmp.enums.error.WxMpConfigErrorEnum;
import pro.haichuang.framework.sdk.wxmp.exception.WxMpConfigException;
import pro.haichuang.framework.sdk.wxmp.exception.WxMpExecuteException;
import pro.haichuang.framework.sdk.wxmp.key.WxMpKey;
import pro.haichuang.framework.sdk.wxmp.service.WxMpService;
import pro.haichuang.framework.sdk.wxmp.store.WxMpDataStore;
import pro.haichuang.framework.sdk.wxmp.util.WxMpUtils;

public class DefaultWxMpServiceImpl
implements WxMpService {
    @Autowired
    private WxMpProperties wxMpProperties;
    @Autowired
    private WxMpDataStore wxMpDataStore;

    @Override
    public void verifyWxMessage(String signature, String timestamp, String nonce, String echoStr, HttpServletResponse response) {
        this.validateProperties();
        String token = this.wxMpProperties.getToken();
        if (token == null || token.isEmpty()) {
            throw new WxMpConfigException(WxMpConfigErrorEnum.Token_NOT_CONFIGURED);
        }
        if (WxMpUtils.checkSignature(this.wxMpProperties.getToken(), signature, timestamp, nonce)) {
            ResponseUtils.writeOfOriginal((HttpServletResponse)response, (Object)echoStr);
        } else {
            ResponseUtils.writeOfJson((HttpServletResponse)response, (Object)ResultVO.other((BaseEnum)AuthorityErrorEnum.ACCESS_BLOCKED));
        }
    }

    @Override
    public String getBaseAccessToken() throws WxMpExecuteException {
        this.validateProperties();
        String baseAccessToken = this.wxMpDataStore.getBaseAccessToken(WxMpKey.baseAccessToken());
        if (baseAccessToken == null || baseAccessToken.isEmpty()) {
            WxMpBaseAccessTokenDTO wxMpBaseAccessTokenDTO = WxMpUtils.getBaseAccessToken(this.wxMpProperties.getAppId(), this.wxMpProperties.getAppSecret());
            baseAccessToken = wxMpBaseAccessTokenDTO.getAccessToken();
            this.wxMpDataStore.setBaseAccessToken(WxMpKey.baseAccessToken(), wxMpBaseAccessTokenDTO.getAccessToken(), wxMpBaseAccessTokenDTO.getAccessTokenExpireTime());
        }
        return baseAccessToken;
    }

    @Override
    public WxMpWebAccessTokenDTO getWebAccessTokenByOpenId(String openId) throws WxMpExecuteException {
        this.validateProperties();
        WxMpWebAccessTokenDTO wxMpWebAccessTokenDTO = null;
        String webAccessToken = this.wxMpDataStore.getWebAccessToken(WxMpKey.webAccessToken(openId));
        String webRefreshAccessToken = this.wxMpDataStore.getWebRefreshAccessToken(WxMpKey.webRefreshAccessToken(openId));
        if (webAccessToken != null && !webAccessToken.isEmpty()) {
            wxMpWebAccessTokenDTO = new WxMpWebAccessTokenDTO();
            wxMpWebAccessTokenDTO.setWebAccessToken(webAccessToken).setWebRefreshToken(webRefreshAccessToken).setOpenId(openId);
        }
        if (webRefreshAccessToken != null && !webRefreshAccessToken.isEmpty()) {
            wxMpWebAccessTokenDTO = WxMpUtils.refreshWebAccessToken(this.wxMpProperties.getAppId(), webRefreshAccessToken);
            this.wxMpDataStore.setWebAccessToken(WxMpKey.webAccessToken(openId), wxMpWebAccessTokenDTO.getWebAccessToken(), wxMpWebAccessTokenDTO.getWebAccessTokenExpireTime());
            this.wxMpDataStore.setWebRefreshAccessToken(WxMpKey.webRefreshAccessToken(openId), wxMpWebAccessTokenDTO.getWebRefreshToken(), wxMpWebAccessTokenDTO.getWebRefreshTokenExpireTime());
        }
        return wxMpWebAccessTokenDTO;
    }

    @Override
    public WxMpWebAccessTokenDTO getWebAccessTokenByCode(String code) throws WxMpExecuteException {
        this.validateProperties();
        WxMpWebAccessTokenDTO wxMpWebAccessTokenDTO = WxMpUtils.getWebAccessToken(this.wxMpProperties.getAppId(), this.wxMpProperties.getAppSecret(), code);
        this.wxMpDataStore.setWebAccessToken(WxMpKey.webAccessToken(wxMpWebAccessTokenDTO.getOpenId()), wxMpWebAccessTokenDTO.getWebAccessToken(), wxMpWebAccessTokenDTO.getWebAccessTokenExpireTime());
        this.wxMpDataStore.setWebRefreshAccessToken(WxMpKey.webRefreshAccessToken(wxMpWebAccessTokenDTO.getOpenId()), wxMpWebAccessTokenDTO.getWebRefreshToken(), wxMpWebAccessTokenDTO.getWebRefreshTokenExpireTime());
        return wxMpWebAccessTokenDTO;
    }

    @Override
    public String getJsApiTicket() throws WxMpExecuteException {
        this.validateProperties();
        String wxMpJsApiTicket = this.wxMpDataStore.getJsApiTicket(WxMpKey.jsApiTicket());
        if (wxMpJsApiTicket == null || !wxMpJsApiTicket.isEmpty()) {
            WxMpJsApiTicketDTO wxMpJsApiTicketDTO = WxMpUtils.getJsApiTicket(this.getBaseAccessToken());
            wxMpJsApiTicket = wxMpJsApiTicketDTO.getTicket();
            this.wxMpDataStore.setJsApiTicket(WxMpKey.jsApiTicket(), wxMpJsApiTicket, wxMpJsApiTicketDTO.getEffectiveTime());
        }
        return wxMpJsApiTicket;
    }

    @Override
    public WxMpUserInfoDTO getUserInfo(String openId) throws WxMpExecuteException {
        return WxMpUtils.getUserInfo(this.getBaseAccessToken(), openId);
    }

    private void validateProperties() {
        String appId = this.wxMpProperties.getAppId();
        String appSecret = this.wxMpProperties.getAppSecret();
        if (appId == null) {
            throw new WxMpConfigException(WxMpConfigErrorEnum.ACCESS_ID_NOT_CONFIGURED);
        }
        if (appSecret == null) {
            throw new WxMpConfigException(WxMpConfigErrorEnum.ACCESS_ID_NOT_CONFIGURED);
        }
    }
}

