/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public final class ListPartition<T>
extends AbstractList<List<? super T>> {
    private final List<? extends T> list;
    private int sublistSize;

    private ListPartition(List<? extends T> list) {
        this.list = new ArrayList<T>(list);
    }

    public static <T> ListPartition<T> of(List<? extends T> list) {
        Objects.requireNonNull(list, "List cannot be null");
        return new ListPartition<T>(list);
    }

    public ListPartition<T> into(int sublistSize) {
        Validate.isTrue((sublistSize > 0 ? 1 : 0) != 0, (String)"Sub-list size must be greater than 0.", (Object[])new Object[0]);
        this.sublistSize = sublistSize;
        return this;
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.sublistSize;
        int end = Math.min(start + this.sublistSize, this.list.size());
        if (start > end) {
            throw new IndexOutOfBoundsException(String.format("Index %d is out of the list range <0,%d>", index, this.size() - 1));
        }
        return new ArrayList<T>(this.list.subList(start, end));
    }

    @Override
    public int size() {
        return (int)Math.ceil((double)this.list.size() / (double)this.sublistSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ListPartition) {
            if (!super.equals(o)) {
                return false;
            }
            ListPartition listPartition = (ListPartition)o;
            return this.sublistSize == listPartition.sublistSize && this.list.equals(listPartition.list);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.list, this.sublistSize);
    }
}

