/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import org.javatuples.Pair;
import pro.horde.os.cutils.function.Dealer;

public final class Idler<T>
implements Supplier<T>,
Dealer<T>,
Serializable {
    private static final long serialVersionUID = -909341387550414732L;
    private transient Supplier<? extends T> supplier;
    private transient Dealer<? extends T> dealer;
    private transient Pair<? extends T, ? extends T> pair = Pair.with(null, null);

    private Idler(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    private Idler(Dealer<? extends T> dealer) {
        this.dealer = dealer;
    }

    private Idler(Dealer<? extends T> dealer, Supplier<? extends T> supplier) {
        this.dealer = dealer;
        this.supplier = supplier;
    }

    public static <T> Idler<T> of(Dealer<? extends T> dealer, Supplier<T> supplier) {
        return Idler.of(supplier, dealer);
    }

    public static <T> Idler<T> of(Supplier<? extends T> supplier, Dealer<? extends T> dealer) {
        Objects.requireNonNull(dealer, "dealer cannot be null");
        Objects.requireNonNull(supplier, "supplier cannot be null");
        return new Idler<T>(dealer, supplier);
    }

    public static <T> Supplier<T> supply(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        return new Idler<T>(supplier);
    }

    public static <T> Dealer<T> deal(Dealer<? extends T> dealer) {
        Objects.requireNonNull(dealer, "dealer cannot be null");
        return new Idler<T>(dealer);
    }

    @Override
    public T deal() throws Exception {
        if (Objects.nonNull(this.dealer) && Objects.isNull(this.pair.getValue1())) {
            this.pair = this.pair.setAt1(this.dealer.deal());
        }
        return (T)this.pair.getValue1();
    }

    @Override
    public T get() {
        if (Objects.nonNull(this.supplier) && Objects.isNull(this.pair.getValue0())) {
            this.pair = this.pair.setAt0(this.supplier.get());
        }
        return (T)this.pair.getValue0();
    }

    public int hashCode() {
        int result = this.supplier != null ? this.supplier.hashCode() : 0;
        result = 31 * result + (this.dealer != null ? this.dealer.hashCode() : 0);
        result = 31 * result + this.pair.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Idler) {
            Idler idler = (Idler)o;
            if (Objects.equals(this.supplier, idler.supplier)) {
                if (!Objects.equals(this.dealer, idler.dealer)) {
                    return false;
                }
                return this.pair.equals(idler.pair);
            }
            return false;
        }
        return false;
    }
}

