/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import pro.horde.os.cutils.function.LazyFunction;

public final class LazyUnaryOperator<T>
implements UnaryOperator<T>,
Serializable {
    private static final long serialVersionUID = 9181168161835004440L;
    private final transient Function<T, T> state;

    private LazyUnaryOperator(UnaryOperator<T> operator) {
        this.state = LazyFunction.of(operator);
    }

    public static <T> UnaryOperator<T> of(UnaryOperator<T> operator) {
        Objects.requireNonNull(operator, "operator cannot be null");
        return new LazyUnaryOperator<T>(operator);
    }

    @Override
    public T apply(T t) {
        return this.state.apply(t);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LazyUnaryOperator) {
            LazyUnaryOperator that = (LazyUnaryOperator)o;
            return this.state.equals(that.state);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }
}

