/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.function;

import java.util.Objects;
import java.util.function.UnaryOperator;
import pro.horde.os.cutils.function.ThrowingFunction;

@FunctionalInterface
public interface ThrowingUnaryOperation<T>
extends ThrowingFunction<T, T> {
    public static <T> UnaryOperator<T> identity() {
        return t -> t;
    }

    public static <T extends Exception, R> R sneakyThrow(Exception ex) throws T {
        throw ex;
    }

    public static <T> UnaryOperator<T> unchecked(ThrowingUnaryOperation<T> operator) {
        Objects.requireNonNull(operator, "operator cannot be null");
        return argument -> {
            try {
                return operator.apply(argument);
            }
            catch (Exception ex) {
                return ThrowingUnaryOperation.sneakyThrow(ex);
            }
        };
    }
}

