/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.security;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;
import pro.horde.os.cutils.Serialization;

public final class AES<T>
implements Serializable {
    private static final long serialVersionUID = 977987773346721438L;
    private static final String DEFAULT_KEY = "Set yours with: `AES.init('fW&yNtP2peBndT5Hz&')`";
    private final transient Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
    private final SecretKeySpec secretKey;
    private static final int GCM_IV_LENGTH = 12;
    private final byte[] aad;

    private AES(Algorithm algorithm, String encryptionKey) throws NoSuchPaddingException, NoSuchAlgorithmException {
        this.aad = encryptionKey.getBytes(StandardCharsets.UTF_8);
        byte[] key = this.aad;
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm.type);
        key = Arrays.copyOf(messageDigest.digest(key), 16);
        this.secretKey = new SecretKeySpec(key, "AES");
    }

    public static <T> AES<T> init() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return AES.init(DEFAULT_KEY);
    }

    public static <T> AES<T> init(String encryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Objects.requireNonNull(encryptionKey, "encryption Key cannot be null");
        return new AES<T>(Algorithm.SHA256, encryptionKey);
    }

    public static <T> AES<T> init(Algorithm algorithm, String encryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Objects.requireNonNull(encryptionKey, "encryption Key cannot be null");
        return new AES<T>(Objects.isNull((Object)algorithm) ? Algorithm.SHA256 : algorithm, encryptionKey);
    }

    public static <T> AES<T> init(Algorithm algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return AES.init(algorithm, DEFAULT_KEY);
    }

    public String encrypt(@Valid T itemToEncrypt) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty(itemToEncrypt), (String)"Item to encrypt cannot be null.", (Object[])new Object[]{itemToEncrypt});
        Supplier<byte[]> ivSupplier = () -> {
            SecureRandom secureRandom = new SecureRandom();
            byte[] iv = new byte[12];
            do {
                secureRandom.nextBytes(iv);
            } while (iv[0] == 0);
            return iv;
        };
        byte[] iv = ivSupplier.get();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        this.cipher.init(1, (Key)this.secretKey, parameterSpec);
        if (Objects.nonNull(this.aad)) {
            this.cipher.updateAAD(this.aad);
        }
        byte[] serializeData = Serialization.serialize(itemToEncrypt);
        byte[] cipherText = this.cipher.doFinal(serializeData);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherText.length);
        byteBuffer.put(iv);
        byteBuffer.put(cipherText);
        return Base64.getEncoder().encodeToString(byteBuffer.array());
    }

    public T decrypt(@NotNull String itemToDecrypt) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)itemToDecrypt), (String)"Item to decrypt cannot be null.", (Object[])new Object[]{itemToDecrypt});
        byte[] cipherMessage = Base64.getDecoder().decode(itemToDecrypt);
        GCMParameterSpec spec = new GCMParameterSpec(128, cipherMessage, 0, 12);
        this.cipher.init(2, (Key)this.secretKey, spec);
        if (Objects.nonNull(this.aad)) {
            this.cipher.updateAAD(this.aad);
        }
        byte[] plainText = this.cipher.doFinal(cipherMessage, 12, cipherMessage.length - 12);
        return (T)SerializationUtils.deserialize((byte[])plainText);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AES) {
            AES aes = (AES)o;
            if (this.cipher.equals(aes.cipher) && this.secretKey.equals(aes.secretKey)) {
                return Arrays.equals(this.aad, aes.aad);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.cipher, this.secretKey);
        result = 31 * result + Arrays.hashCode(this.aad);
        return result;
    }

    public static enum Algorithm {
        MD2("MD2"),
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA224("SHA-224"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String type;

        private Algorithm(String type) {
            this.type = type;
        }
    }
}

