/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.function;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class LazyFunction<T, R>
implements Function<T, R>,
Serializable {
    private static final long serialVersionUID = 398334400292617685L;
    private final transient Function<? super T, ? extends R> function;
    private final transient Map<T, R> store = new ConcurrentHashMap<T, R>();

    private LazyFunction(Function<? super T, ? extends R> function) {
        this.function = function;
    }

    public static <T, R> Function<T, R> of(Function<? super T, ? extends R> function) {
        Objects.requireNonNull(function, "function cannot be null");
        return new LazyFunction<T, R>(function);
    }

    @Override
    public R apply(T t) {
        if (this.store.containsKey(t)) {
            return this.store.get(t);
        }
        R value = this.function.apply(t);
        this.store.putIfAbsent(t, value);
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LazyFunction) {
            LazyFunction that = (LazyFunction)o;
            return this.function.equals(that.function) && this.store.equals(that.store);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.function, this.store);
    }
}

