/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.string;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.apache.commons.lang3.Validate;

public class StringIncubator
implements Serializable {
    private static final long serialVersionUID = 3793946601043438484L;
    private final Random random;
    private final char[] symbols;
    private final char[] buffer;
    private static String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String lower = StringIncubator.getUpper().toLowerCase(Locale.ROOT);
    public static final String DIGITS = "0123456789";
    private static final String ALPHANUM = StringIncubator.getUpper() + StringIncubator.getLower() + "0123456789";

    public StringIncubator(int length, Random random, String symbols) {
        this.symbols = Objects.requireNonNull(symbols, "symbols cannot be null").toCharArray();
        Validate.isTrue((length > 1 ? 1 : 0) != 0, (String)"String length cannot be less than 1", (long)length);
        Validate.isTrue((symbols.length() > 2 ? 1 : 0) != 0, (String)"Symbols length cannot be less that 2", (long)symbols.length());
        this.random = Objects.requireNonNull(random);
        this.buffer = new char[length];
    }

    public StringIncubator(int length, Random random) {
        this(length, random, ALPHANUM);
    }

    public StringIncubator(int length, ThreadLocalRandom random) {
        this(length, random, ALPHANUM);
    }

    public StringIncubator(int length) {
        this(length, new SecureRandom());
    }

    public StringIncubator(int length, String symbols) {
        this(length, new SecureRandom(), symbols);
    }

    public StringIncubator() {
        this(64);
    }

    public static String getUpper() {
        return upper;
    }

    public static void setUpper(String uppercaseValue) {
        upper = uppercaseValue.toUpperCase();
    }

    public static String getLower() {
        return lower;
    }

    public static void setLower(String lowercaseValue) {
        lower = lowercaseValue.toLowerCase();
    }

    public String hatch() {
        IntStream.range(0, this.buffer.length).forEachOrdered(idx -> {
            this.buffer[idx] = this.symbols[this.random.nextInt(this.symbols.length)];
        });
        return String.valueOf(this.buffer);
    }
}

