/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.value;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import pro.horde.os.cutils.function.Dealer;
import pro.horde.os.cutils.function.Executable;
import pro.horde.os.cutils.value.Try;

public final class Pause<T> {
    private final Run<T> run;

    private Pause(int timeOut) {
        this.run = new Run(timeOut);
    }

    public static <T> Pause<T> until(int timeOut) {
        return new Pause<T>(timeOut);
    }

    public Run<T> nanoSeconds() {
        return ((Run)this.run).setTimeUnit(TimeUnit.NANOSECONDS);
    }

    public Run<T> microSeconds() {
        return ((Run)this.run).setTimeUnit(TimeUnit.MICROSECONDS);
    }

    public Run<T> milliSeconds() {
        return ((Run)this.run).setTimeUnit(TimeUnit.MILLISECONDS);
    }

    public Run<T> seconds() {
        return ((Run)this.run).setTimeUnit(TimeUnit.SECONDS);
    }

    public Run<T> minute() {
        return ((Run)this.run).setTimeUnit(TimeUnit.MINUTES);
    }

    public Run<T> hours() {
        return ((Run)this.run).setTimeUnit(TimeUnit.HOURS);
    }

    public Run<T> days() {
        return ((Run)this.run).setTimeUnit(TimeUnit.DAYS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pause) {
            Pause pause = (Pause)o;
            return this.run.equals(pause.run);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.run);
    }

    public static final class Run<T> {
        private final int timeOut;
        private TimeUnit timeUnit;

        private Run(int timeOut) {
            this.timeOut = timeOut;
        }

        private Run<T> setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Delay<T> thenRun(Executable executable) {
            return new Delay(this.timeOut, this.timeUnit, executable);
        }

        public Delay<T> thenRun(Dealer<T> dealer) {
            return new Delay(this.timeOut, this.timeUnit, dealer);
        }

        public Delay<T> empty() {
            return new Delay(this.timeOut, this.timeUnit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Run) {
                Run run = (Run)o;
                return this.timeOut == run.timeOut && this.timeUnit == run.timeUnit;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.timeOut, this.timeUnit});
        }

        public static final class Delay<T> {
            private final Try<T> tryResult;

            private Delay(int timeOut, TimeUnit timeUnit) {
                this.tryResult = Try.of(() -> timeUnit.sleep(timeOut));
            }

            private Delay(int timeOut, TimeUnit timeUnit, Executable executable) {
                this.tryResult = Try.of(() -> {
                    timeUnit.sleep(timeOut);
                    executable.execute();
                });
            }

            private Delay(int timeOut, TimeUnit timeUnit, Dealer<T> dealer) {
                this.tryResult = Try.of(() -> {
                    timeUnit.sleep(timeOut);
                    return dealer.deal();
                });
            }

            public Try<T> get() {
                return this.tryResult;
            }

            public void onComplete(Consumer<Try<T>> tryResult) {
                tryResult.accept(this.tryResult);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o instanceof Delay) {
                    Delay delay = (Delay)o;
                    return this.tryResult.equals(delay.tryResult);
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.tryResult);
            }
        }
    }
}

