/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.value;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import pro.horde.os.cutils.function.Accepter;
import pro.horde.os.cutils.function.Dealer;
import pro.horde.os.cutils.function.Executable;

public final class Que<T>
implements Serializable {
    private static final long serialVersionUID = 2637789154313032412L;
    private static Que<?> instance;
    private final transient T value;

    private Que() {
        this.value = null;
    }

    private Que(T value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> Que<T> getInstance() {
        if (!Objects.isNull(instance)) return instance;
        Class<Que> clazz = Que.class;
        synchronized (Que.class) {
            if (!Objects.isNull(instance)) return instance;
            instance = new Que<T>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static <T> Que<T> of(T value) {
        return Que.createReference(value);
    }

    public static <T> Que<T> of(Supplier<? extends T> supplier) {
        return Que.createReference(supplier.get());
    }

    private static <T> Que<T> createReference(T value) {
        return new Que<T>(value);
    }

    public static <T> Que<T> as(Dealer<? extends T> dealer) throws Exception {
        Objects.requireNonNull(dealer, "dealer cannot be null");
        return Que.createReference(dealer.deal());
    }

    public static <T> Que<T> run(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable cannot be null");
        runnable.run();
        return Que.getInstance();
    }

    public Que<T> run(Consumer<? super T> consumer) {
        return this.consumer(consumer);
    }

    public static <T> Que<T> execute(Executable executable) throws Exception {
        Objects.requireNonNull(executable, "executable cannot be null");
        executable.execute();
        return Que.getInstance();
    }

    public Que<T> execute(Accepter<? super T> accepter) throws Exception {
        return this.accepter(accepter);
    }

    public Que<T> andRun(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable cannot be null");
        runnable.run();
        return this;
    }

    public Que<T> andExecute(Executable executable) throws Exception {
        Objects.requireNonNull(executable, "executable cannot be null");
        executable.execute();
        return this;
    }

    public Que<T> andSupply(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        return Que.createReference(supplier.get());
    }

    public Que<T> andDeal(Dealer<? extends T> dealer) throws Exception {
        Objects.requireNonNull(dealer, "dealer cannot be null");
        return Que.createReference(dealer.deal());
    }

    private Que<T> consumer(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer cannot be null");
        consumer.accept(this.value);
        return this;
    }

    public Que<T> andConsume(Consumer<? super T> consumer) {
        return this.consumer(consumer);
    }

    public Que<T> andAccept(Accepter<? super T> accepter) throws Exception {
        return this.accepter(accepter);
    }

    private Que<T> accepter(Accepter<? super T> accepter) throws Exception {
        Objects.requireNonNull(accepter, "accepter cannot be null");
        accepter.accept(this.value);
        return this;
    }

    public Que<T> andCall(Callable<? extends T> callable) throws Exception {
        Objects.requireNonNull(callable, "callable cannot be null");
        return Que.createReference(callable.call());
    }

    public T get() {
        return this.value;
    }

    public CompletableFuture<T> completableFuture() {
        return CompletableFuture.completedFuture(this.value);
    }

    public Optional<T> optional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Que) {
            Que que = (Que)o;
            return this.value.equals(que.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

