/*
 * Decompiled with CFR 0.152.
 */
package pro.horde.os.cutils.value;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import pro.horde.os.cutils.function.Dealer;
import pro.horde.os.cutils.function.Executable;

public abstract class Try<T>
implements Serializable {
    private static final long serialVersionUID = 4530258067856316628L;

    private Try() {
    }

    public static <T> Try<T> of(Dealer<? extends T> operation) {
        Objects.requireNonNull(operation, "operation cannot be null");
        try {
            return new Success(operation.deal());
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    public static <T> Try<T> of(Executable operation) {
        Objects.requireNonNull(operation, "operation cannot be null");
        try {
            operation.execute();
            return new Success();
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    public void onSuccess(Consumer<? super T> resultConsumer) {
        if (this.isSuccess()) {
            resultConsumer.accept(this.get());
        }
    }

    public void onFailure(Consumer<? super Throwable> exceptionConsumer) {
        if (this.isFailure()) {
            exceptionConsumer.accept(this.getCause());
        }
    }

    public void onSuccessOrElse(Consumer<? super T> resultConsumer, Runnable action) {
        if (this.isSuccess()) {
            resultConsumer.accept(this.get());
        } else {
            action.run();
        }
    }

    public void onSuccessOrElse(Consumer<? super T> resultConsumer, Consumer<? super Throwable> exceptionConsumer) {
        if (this.isSuccess()) {
            resultConsumer.accept(this.get());
        } else {
            exceptionConsumer.accept(this.getCause());
        }
    }

    public void onFailureOrElse(Consumer<? super Throwable> exceptionConsumer, Runnable action) {
        if (this.isFailure()) {
            exceptionConsumer.accept(this.getCause());
        } else {
            action.run();
        }
    }

    public void onFailureOrElse(Consumer<? super Throwable> exceptionConsumer, Consumer<? super T> resultConsumer) {
        if (this.isFailure()) {
            exceptionConsumer.accept(this.getCause());
        } else {
            resultConsumer.accept(this.get());
        }
    }

    public abstract T get();

    public abstract Throwable getCause();

    public abstract <M> Try<M> map(Function<? super T, ? extends M> var1);

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<? extends T> var1);

    public abstract <X extends Throwable> T orElseThrow(Supplier<? extends X> var1) throws X;

    public abstract boolean isSuccess();

    public abstract boolean isResult();

    public abstract boolean isFailure();

    private static class Failure<F>
    extends Try<F>
    implements Serializable {
        private static final long serialVersionUID = 6137465851350394283L;
        private final transient Throwable exception;

        private Failure(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public F get() {
            throw new UnsupportedOperationException("No result available, operation failed with an exception.");
        }

        @Override
        public Throwable getCause() {
            return this.exception;
        }

        @Override
        public <M> Try<M> map(Function<? super F, ? extends M> mapper) {
            throw new UnsupportedOperationException("No result available to map, operation failed with an exception.");
        }

        @Override
        public F orElse(F other) {
            return other;
        }

        @Override
        public F orElseGet(Supplier<? extends F> other) {
            return other.get();
        }

        @Override
        public <X extends Throwable> F orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isResult() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Failure) {
                Failure failure = (Failure)o;
                return this.exception.equals(failure.exception);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.exception);
        }
    }

    private static class Success<S>
    extends Try<S>
    implements Serializable {
        private static final long serialVersionUID = 4332649928027329163L;
        private final boolean isResult;
        private final transient S result;

        private Success() {
            this.isResult = false;
            this.result = null;
        }

        private Success(S result) {
            this.isResult = true;
            this.result = result;
        }

        @Override
        public Throwable getCause() {
            throw new UnsupportedOperationException("Operation was successful, without any exception thrown.");
        }

        @Override
        public <M> Try<M> map(Function<? super S, ? extends M> mapper) {
            Objects.requireNonNull(mapper, "mapper cannot be null");
            if (this.isResult()) {
                return Try.of(() -> mapper.apply((S)this.result));
            }
            throw new IllegalStateException("No result available to map.");
        }

        @Override
        public S orElse(S other) {
            return this.get();
        }

        @Override
        public S orElseGet(Supplier<? extends S> other) {
            return this.get();
        }

        @Override
        public <X extends Throwable> S orElseThrow(Supplier<? extends X> exceptionSupplier) {
            return this.get();
        }

        @Override
        public S get() {
            if (this.isResult) {
                return this.result;
            }
            throw new IllegalStateException("Operation has no result available.");
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isResult() {
            return this.isResult;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Success) {
                Success success = (Success)o;
                return this.isResult() == success.isResult() && this.result == success.result;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.isResult(), this.result);
        }
    }
}

