/*
 * Decompiled with CFR 0.152.
 */
package pro.jaitl.dynamodb.mapper.converter.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import pro.jaitl.dynamodb.mapper.KDynamoMapperReader;
import pro.jaitl.dynamodb.mapper.KDynamoMapperWriter;
import pro.jaitl.dynamodb.mapper.UnknownTypeException;
import pro.jaitl.dynamodb.mapper.attribute.TypesKt;
import pro.jaitl.dynamodb.mapper.converter.TypeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u0004\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Lpro/jaitl/dynamodb/mapper/converter/type/NumberConverter;", "Lpro/jaitl/dynamodb/mapper/converter/TypeConverter;", "", "()V", "read", "str", "", "kType", "Lkotlin/reflect/KType;", "reader", "Lpro/jaitl/dynamodb/mapper/KDynamoMapperReader;", "attr", "Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "type", "Lkotlin/reflect/KClass;", "write", "writer", "Lpro/jaitl/dynamodb/mapper/KDynamoMapperWriter;", "value", "", "lib"})
public final class NumberConverter
implements TypeConverter<Number> {
    @Override
    @NotNull
    public Number read(@NotNull KDynamoMapperReader reader, @NotNull AttributeValue attr, @NotNull KType kType) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        String string = attr.n();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr.n()");
        return this.read(string, kType);
    }

    @NotNull
    public final Number read(@NotNull String str, @NotNull KType kType) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        KClassifier kClassifier = kType.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            String string = str;
            boolean bl = false;
            number = Byte.parseByte(string);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            String string = str;
            boolean bl = false;
            number = Short.parseShort(string);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            String string = str;
            boolean bl = false;
            number = Integer.parseInt(string);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            String string = str;
            boolean bl = false;
            number = Long.parseLong(string);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            String string = str;
            boolean bl = false;
            number = Float.valueOf(Float.parseFloat(string));
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            String string = str;
            boolean bl = false;
            number = Double.parseDouble(string);
        } else {
            throw new UnknownTypeException("Unknown type: " + kType.getClassifier());
        }
        return number;
    }

    @Override
    @NotNull
    public AttributeValue write(@NotNull KDynamoMapperWriter writer, @NotNull Object value, @NotNull KType kType) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        return TypesKt.numberAttribute((Number)value);
    }

    @Override
    @NotNull
    public KClass<Number> type() {
        return Reflection.getOrCreateKotlinClass(Number.class);
    }
}

