/*
 * Decompiled with CFR 0.152.
 */
package pro.jaitl.dynamodb.mapper.converter.type;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import pro.jaitl.dynamodb.mapper.KDynamoMapperReader;
import pro.jaitl.dynamodb.mapper.KDynamoMapperWriter;
import pro.jaitl.dynamodb.mapper.attribute.TypesKt;
import pro.jaitl.dynamodb.mapper.converter.TypeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lpro/jaitl/dynamodb/mapper/converter/type/UUIDConverter;", "Lpro/jaitl/dynamodb/mapper/converter/TypeConverter;", "Ljava/util/UUID;", "()V", "read", "reader", "Lpro/jaitl/dynamodb/mapper/KDynamoMapperReader;", "attr", "Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "kType", "Lkotlin/reflect/KType;", "type", "Lkotlin/reflect/KClass;", "write", "writer", "Lpro/jaitl/dynamodb/mapper/KDynamoMapperWriter;", "value", "", "lib"})
public final class UUIDConverter
implements TypeConverter<UUID> {
    @Override
    @NotNull
    public UUID read(@NotNull KDynamoMapperReader reader, @NotNull AttributeValue attr, @NotNull KType kType) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        UUID uUID = UUID.fromString(attr.s());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(attr.s())");
        return uUID;
    }

    @Override
    @NotNull
    public AttributeValue write(@NotNull KDynamoMapperWriter writer, @NotNull Object value, @NotNull KType kType) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        String string = ((UUID)value).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value as UUID).toString()");
        return TypesKt.stringAttribute(string);
    }

    @Override
    @NotNull
    public KClass<UUID> type() {
        return Reflection.getOrCreateKotlinClass(UUID.class);
    }
}

