/*
 * Decompiled with CFR 0.152.
 */
package pro.jaitl.dynamodb.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import pro.jaitl.dynamodb.mapper.ConverterRegistry;
import pro.jaitl.dynamodb.mapper.ConverterRegistryKt;
import pro.jaitl.dynamodb.mapper.KDynamoMapperReader;
import pro.jaitl.dynamodb.mapper.NotDataClassTypeException;
import pro.jaitl.dynamodb.mapper.RequiredFieldNotFoundException;
import pro.jaitl.dynamodb.mapper.UnknownTypeException;
import pro.jaitl.dynamodb.mapper.converter.TypeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J9\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u000fH\u0002\u00a2\u0006\u0002\u0010\u0014J9\u0010\u0015\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00110\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpro/jaitl/dynamodb/mapper/Reader;", "Lpro/jaitl/dynamodb/mapper/KDynamoMapperReader;", "registry", "Lpro/jaitl/dynamodb/mapper/ConverterRegistry;", "(Lpro/jaitl/dynamodb/mapper/ConverterRegistry;)V", "checkRequiredFields", "", "obj", "", "", "Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "args", "", "Lkotlin/reflect/KParameter;", "clazz", "Lkotlin/reflect/KClass;", "handleAdt", "T", "", "kClass", "(Ljava/util/Map;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "readObject", "readParameter", "param", "readValue", "attr", "kType", "Lkotlin/reflect/KType;", "lib"})
public final class Reader
implements KDynamoMapperReader {
    @NotNull
    private final ConverterRegistry registry;

    public Reader(@NotNull ConverterRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
    }

    public /* synthetic */ Reader(ConverterRegistry converterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            converterRegistry = ConverterRegistryKt.getDEFAULT_REGISTRY();
        }
        this(converterRegistry);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> T readObject(@NotNull Map<String, AttributeValue> obj, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (clazz.isSealed()) {
            return this.handleAdt(obj, clazz);
        }
        if (!clazz.isData()) {
            throw new NotDataClassTypeException("Type '" + clazz + "' isn't a data class type");
        }
        KFunction kFunction = KClasses.getPrimaryConstructor(clazz);
        Intrinsics.checkNotNull((Object)kFunction);
        KFunction constructor = kFunction;
        List args = constructor.getParameters();
        this.checkRequiredFields(obj, args, clazz);
        Iterable $this$associateWith$iv = args;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            KParameter kParameter = (KParameter)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object object = this.readParameter((KParameter)it, obj);
            map.put(t, object);
        }
        Map params = result$iv;
        return (T)constructor.callBy(params);
    }

    private final <T> T handleAdt(Map<String, AttributeValue> obj, KClass<T> kClass) {
        String realClazz;
        AttributeValue attributeValue = obj.get("adt_class_name");
        String string = realClazz = attributeValue == null ? null : attributeValue.s();
        if (realClazz == null) {
            throw new RequiredFieldNotFoundException("ADT '" + kClass + "' has to contain attribute 'adt_class_name'", SetsKt.setOf((Object)"adt_class_name"));
        }
        Class<?> clazz = Class.forName(realClazz);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(realClazz)");
        KClass adtClazz = JvmClassMappingKt.getKotlinClass(clazz);
        if (!KClasses.isSuperclassOf(kClass, (KClass)adtClazz)) {
            throw new UnknownTypeException("Class '" + kClass.getQualifiedName() + "' isn't a subclass of '" + adtClazz + "'");
        }
        return this.readObject(obj, adtClazz);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRequiredFields(Map<String, AttributeValue> obj, List<? extends KParameter> args, KClass<?> clazz) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterNotTo$iv$iv;
        Set<String> foundFields = obj.keySet();
        Iterable $this$filterNot$iv = args;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KParameter it = (KParameter)element$iv$iv;
            boolean bl = false;
            if (it.getType().isMarkedNullable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KParameter it = (KParameter)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set requiredFields = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set notFoundFields = SetsKt.minus((Set)requiredFields, (Iterable)foundFields);
        Collection collection = notFoundFields;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new RequiredFieldNotFoundException("Required fields not found: [" + CollectionsKt.joinToString$default((Iterable)notFoundFields, (CharSequence)", ", (CharSequence)"'", (CharSequence)"'", (int)0, null, null, (int)56, null) + "] for " + clazz, notFoundFields);
        }
    }

    private final Object readParameter(KParameter param, Map<String, AttributeValue> obj) {
        Map<String, AttributeValue> map = obj;
        String string = param.getName();
        boolean bl = false;
        AttributeValue attr = map.get(string);
        if (attr == null) {
            return null;
        }
        return this.readValue(attr, param.getType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object readValue(@NotNull AttributeValue attr, @NotNull KType kType) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        Object object = kType.getClassifier();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        }
        KClass clazz = (KClass)object;
        if (clazz.isData() || clazz.isSealed()) {
            object = attr.m();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attr.m()");
            return this.readObject((Map<String, AttributeValue>)object, clazz);
        }
        TypeConverter<?> converter = this.registry.getRegistry().get(clazz);
        if (converter != null) {
            return converter.read(this, attr, kType);
        }
        Iterable $this$mapNotNull$iv = clazz.getSupertypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TypeConverter<?> typeConverter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KType it = (KType)element$iv$iv;
            boolean bl2 = false;
            Map<KClass<?>, TypeConverter<?>> map = this.registry.getRegistry();
            KClassifier kClassifier = it.getClassifier();
            boolean bl3 = false;
            if (map.get(kClassifier) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            TypeConverter<?> it$iv$iv = typeConverter;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List superClasses = (List)destination$iv$iv;
        Collection collection = superClasses;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return ((TypeConverter)CollectionsKt.first((List)superClasses)).read(this, attr, kType);
        }
        throw new UnknownTypeException("Unknown type: " + clazz);
    }

    public Reader() {
        this(null, 1, null);
    }
}

