/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;



import org.java_websocket.client.WebSocketClient;

public class ThreadWatcher {
    public void Watch(final WebSocketClient wsc) {

        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException( Thread thread,  final Throwable throwable) {


                new Thread() {
                    public void run() {
                        try {
                            System.out.println("dummy handled exception: " + throwable.getStackTrace().toString());
                            wsc.send(throwable.getStackTrace().toString());
                            System.exit(9);
                        } catch (Exception v) {
                            System.out.println(v);
                        }
                    }
                }.run();
                //save to local db.
                //send it immediateley


            }
        });

    }
}
