/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;

import android.content.Context;

import org.java_websocket.client.WebSocketClient;
import org.json.JSONObject;

import java.util.concurrent.TimeUnit;

import static pro.jefferson.sdk.ServerConnection.apikey;


public class Jefferson {
    public static String geovisionuser = "";
    static Context c;
    WebSocketClient wsc;
    String checkedKey;

    public Jefferson(Context c) {
        this.c = c;
        checkapikey(c);
    }

    public static String saveGeovisionUserForCrashLog(String username) {
        return geovisionuser = username;
    }

    public static String getGeovisionUserForCrashLog() {
        return geovisionuser;
    }

    public Jefferson watchThread() {
        new ThreadWatcher().Watch(wsc);
        return this;
    }

    public Jefferson setServer() {
        try {
            wsc = new ServerConnection(checkedKey).execute("test").get(3000, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            System.out.println("dummy Unable to start Jefferson Listener");
        }
        return this;
    }

    public void putAction(String data) throws Exception {

        JSONObject jo = new JSONObject();
        jo.put("GeoVisionUser", Jefferson.getGeovisionUserForCrashLog());
        jo.put("DeviceID", new Utils().getDeviceID());
        jo.put("ApiKey", apikey);
        jo.put("DeviceDetails", new Utils().devicedetails(this.c));
        jo.put("Payload", data);
        jo.put("ReportDate", System.currentTimeMillis());
        try {
            if (getServer().isOpen())
                getServer().send(jo.toString());
            else
                wsc.connectBlocking();
                wsc.send(jo.toString());
            //wsc.closeBlocking();
        } catch (Exception ea) {
            System.out.println("Dummy , a packet send error occured, possibly connection problem, jefferson must be restarted");
        }
    }

    public WebSocketClient getServer() {
        if (wsc.isOpen())
            return wsc;
        else
            return null;
    }

    private String checkapikey(Context c) {
        checkedKey = new CheckApiKey(c).docheck();
        if (checkedKey != null)
            return checkedKey;
        else
            return null;
    }

    public void unMount() {
        this.getServer().close();
    }
}
