/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;


import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;

import org.java_websocket.client.WebSocketClient;
import org.json.JSONObject;

import static pro.jefferson.sdk.ServerConnection.apikey;

public class ThreadWatcher implements LocationListener {
    public static Location location;

    public static void Watch(final WebSocketClient wsc) {

        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, final Throwable throwable) {


                new Thread() {
                    public void run() {

                        // System.out.println("dummy handled exception: " + throwable.getStackTrace().toString());
                        //wsc.send(throwable.getStackTrace().toString());

                        try {
                            new Utils().getDeviceID();
                            JSONObject jo = new JSONObject();
                            try{
                                jo.put("Location", location.getLatitude()+","+location.getLongitude());
                            }catch(Exception eee){}

                            jo.put("GeoVisionUser", Jefferson.getGeovisionUserForCrashLog());
                            jo.put("DeviceID", new Utils().getDeviceID());
                            jo.put("ApiKey", apikey);
                            jo.put("DeviceDetails", new Utils().devicedetails(Jefferson.c));
                            jo.put("Payload", throwable.getMessage());
                            jo.put("ReportDate", System.currentTimeMillis());
                            if (wsc.isOpen())
                                wsc.send(jo.toString());
                            else
                                wsc.connectBlocking();
                                wsc.send(jo.toString());
                            // wsc.closeBlocking();

                            // System.out.println("dummy handshake: " + handshakedata.getHttpStatusMessage());
                            //isopen = true;

                        } catch (Exception e) {
                        }
                        System.exit(9);

                    }
                }.run();
                //save to local db.
                //send it immediateley


            }
        });

    }

    public void startLocationListener(Context c) throws SecurityException{

        LocationManager locationManager = (LocationManager) c.getSystemService(Context.LOCATION_SERVICE);
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, this);

    }

    @Override
    public void onLocationChanged(Location location) {
        this.location = location;
    }

    @Override
    public void onStatusChanged(String s, int i, Bundle bundle) {

    }

    @Override
    public void onProviderEnabled(String s) {

    }

    @Override
    public void onProviderDisabled(String s) {

    }
}
