/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;

import org.json.JSONObject;

public class Utils {
    Context c;

    public Utils() {


    }

    public String getDeviceID() {

        // TelephonyManager TelephonyMgr = (TelephonyManager) c.getSystemService(TELEPHONY_SERVICE);
        //  String szImei = TelephonyMgr.getDeviceId(); // Requires READ_PHONE_STATE

        return "n/a";

    }

    public JSONObject devicedetails(Context c) throws Exception {
        boolean isWifiConn = false;
        boolean isMobileConn = false;
        int downstreamkbps=-1;
        try {
            ConnectivityManager connMgr =
                    (ConnectivityManager) c.getSystemService(Context.CONNECTIVITY_SERVICE);
            for (Network network : connMgr.getAllNetworks()) {
                NetworkInfo networkInfo = connMgr.getNetworkInfo(network);
                if (networkInfo.getType() == ConnectivityManager.TYPE_WIFI) {
                    isWifiConn |= networkInfo.isConnected();
                }
                if (networkInfo.getType() == ConnectivityManager.TYPE_MOBILE) {
                    isMobileConn |= networkInfo.isConnected();
                    downstreamkbps=connMgr.getNetworkCapabilities(connMgr.getActiveNetwork()).getLinkDownstreamBandwidthKbps();
                }
            }
        } catch (Exception asd) {
            isWifiConn = false;
            isMobileConn = false;
        }
        System.out.println("Wifi connected: " + isWifiConn);
        System.out.println("Mobile connected: " + isMobileConn);
        System.out.println("NetworkSpeedKBPS: " + downstreamkbps);

        return new JSONObject()
                .put("WifiConnected", isWifiConn)
                .put("MobileConnected", isMobileConn)
                .put("NetworkSpeedKBPS",downstreamkbps)
                .put("APPID", c.getPackageName())
                .put("Brand", Build.BRAND)
                .put("Product", Build.PRODUCT)
                .put("Manufactorer", Build.MANUFACTURER)
                .put("Model", Build.MODEL)
                .put("AndroidVersion", Build.VERSION.SDK_INT)
                .put("appVersion", BuildConfig.VERSION_CODE);

    }
}
