/*
 * Copyright 2019 Jefferson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.jefferson.sdk;

 import android.os.AsyncTask;

import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

import java.net.URI;

public class ServerConnection extends AsyncTask <String , Integer ,WebSocketClient >{
    static boolean isopen = false;
    static String apikey;

    public ServerConnection(String apikey) {
        this.apikey = apikey;
    }


    @Override
    protected WebSocketClient doInBackground(String... strings) {
       return start(this.apikey);

    }

    @Override
    protected void onPostExecute(WebSocketClient webSocketClient) {
        super.onPostExecute(webSocketClient);
    }

    public static WebSocketClient start(final String apikey) {

        final WebSocketClient wsc = new WebSocketClient(URI.create("ws://jefferson.pro:4442")) {
            @Override
            public void onOpen(ServerHandshake handshakedata) {
                try{
                    new Utils().getDeviceID();
                    JSONObject jo =new JSONObject();
                    jo.put("DeviceID",new Utils().getDeviceID());
                    jo.put("ApiKey",apikey);
                    jo.put("DeviceDetails",new Utils().devicedetails(Jefferson.c));
                    jo.put("Payload","initSession");
                    jo.put("ReportDate", System.currentTimeMillis());
                    send(jo.toString());
                    System.out.println("dummy handshake: " + handshakedata.getHttpStatusMessage());
                    isopen = true;

                }catch (Exception e){}


            }

            @Override
            public void onMessage(String message) {
                System.out.println("dummy message: " + message);
                //new AlertDialog.Builder(c).setMessage(message).setTitle("message").setNeutralButton("ok",null).create().show();
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                System.out.println("dummy close: " + code + reason + remote);


            }

            @Override
            public void onError(Exception ex) {
                System.out.println("dummy error: " + ex.getMessage());
            }
        };

        wsc.connect();


        return wsc;
    }


}
